/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.testdetailsviewer.client;

import com.google.gwt.gen2.table.override.client.FlexTable;
import com.google.gwt.i18n.client.Dictionary;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import org.sonar.gwt.ui.ExpandCollapseLink;
import org.sonar.gwt.ui.Loading;
import org.sonar.wsclient.gwt.AbstractCallback;
import org.sonar.wsclient.gwt.Callback;
import org.sonar.wsclient.gwt.Sonar;
import org.sonar.wsclient.services.Measure;
import org.sonar.wsclient.services.Query;
import org.sonar.wsclient.services.Resource;
import org.sonar.wsclient.services.ResourceQuery;

public class TestsPanel
extends Composite {
    private final Panel panel = new VerticalPanel();
    private Loading loading = new Loading();

    public TestsPanel(Resource resource) {
        this.panel.add((Widget)this.loading);
        this.initWidget((Widget)this.panel);
        this.setStyleName("gwt-TestDetailsPanel");
        this.getElement().setId("gwt-TestDetailsPanel");
        this.loadData(resource);
    }

    private void loadData(Resource resource) {
        ResourceQuery query = ResourceQuery.createForResource((Resource)resource, (String[])new String[]{"test_data"});
        Sonar.getInstance().find((Query)query, (Callback)new TestDetailsMeasureHandler());
    }

    private void fillStackPanel(Panel p, com.google.gwt.xml.client.Element stackElement) {
        String message = stackElement.getAttribute("message");
        if (message.length() > 0) {
            p.getElement().setInnerHTML(this.escapeHtml(message) + "<br/>" + this.stackLineBreaks(stackElement.getFirstChild().getNodeValue()));
        } else {
            p.getElement().setInnerHTML(this.stackLineBreaks(stackElement.getFirstChild().getNodeValue()));
        }
    }

    private String escapeHtml(String maybeHtml) {
        Element div = DOM.createDiv();
        div.setInnerText(maybeHtml);
        return div.getInnerHTML();
    }

    private String stackLineBreaks(String s) {
        StringBuilder stack = new StringBuilder(256);
        for (String el : s.split("\n")) {
            stack.append(el.trim()).append("<br/>");
        }
        return stack.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestDetailsMeasureHandler
    extends AbstractCallback<Resource> {
        public TestDetailsMeasureHandler() {
            super((Widget)TestsPanel.this.loading);
        }

        protected void doOnResponse(Resource resource) {
            TestsPanel.this.loading.removeFromParent();
            if (resource != null) {
                Measure measure = resource.getMeasure("test_data");
                this.processTestDetails(measure.getData());
            }
        }

        private void processTestDetails(String testXMLData) {
            Document parsed = XMLParser.parse((String)testXMLData);
            NodeList testcasesXML = parsed.getElementsByTagName("testcase");
            Dictionary l10n = Dictionary.getDictionary((String)"l10n");
            FlexTable table = new FlexTable();
            table.setStylePrimaryName("detailsTable");
            table.setText(0, 0, "");
            table.setText(0, 1, "");
            table.setText(0, 2, l10n.get("unittest.duration"));
            table.setText(0, 3, l10n.get("unittest.name"));
            table.getCellFormatter().getElement(0, 1).setId("iCol");
            table.getCellFormatter().getElement(0, 2).setId("dCol");
            this.setRowStyle(0, table, "header", false);
            int rowCounter = 1;
            for (int i = 0; i < testcasesXML.getLength(); ++i) {
                com.google.gwt.xml.client.Element testcaseXML = (com.google.gwt.xml.client.Element)testcasesXML.item(i);
                String time = testcaseXML.getAttribute("time");
                String name = testcaseXML.getAttribute("name");
                String status = testcaseXML.getAttribute("status");
                com.google.gwt.xml.client.Element error = this.getFirstElement("error", testcaseXML);
                com.google.gwt.xml.client.Element failure = this.getFirstElement("failure", testcaseXML);
                com.google.gwt.xml.client.Element stackTrace = status.equals("error") ? error : failure;
                this.renderTestDetails(rowCounter, i, status, stackTrace, name, time, table);
                rowCounter += 2;
            }
            TestsPanel.this.panel.add((Widget)table);
        }

        private com.google.gwt.xml.client.Element getFirstElement(String elementName, com.google.gwt.xml.client.Element node) {
            NodeList elements = node.getElementsByTagName(elementName);
            return elements.getLength() > 0 ? (com.google.gwt.xml.client.Element)elements.item(0) : null;
        }

        private void renderTestDetails(int row, int testCounter, String testCaseStatus, com.google.gwt.xml.client.Element stackTrace, String name, String timeMS, FlexTable table) {
            HTML icon = new HTML("&nbsp;");
            icon.setStyleName(testCaseStatus);
            table.setWidget(row, 1, (Widget)icon);
            table.setText(row, 2, timeMS + " ms");
            table.setText(row, 3, name);
            String style = testCounter % 2 == 0 ? "odd" : "even";
            this.setRowStyle(row, table, style, false);
            if (stackTrace != null) {
                SimplePanel stackPanel = new SimplePanel();
                stackPanel.setStyleName("stackPanel");
                stackPanel.getElement().setId("stack-panel" + name);
                stackPanel.setVisible(false);
                TestsPanel.this.fillStackPanel((Panel)stackPanel, stackTrace);
                FlexTable.FlexCellFormatter frmt = (FlexTable.FlexCellFormatter)table.getCellFormatter();
                frmt.setColSpan(row + 1, 1, 3);
                table.setWidget(row + 1, 1, (Widget)stackPanel);
                table.setWidget(row, 0, (Widget)new ExpandCollapseLink((Widget)stackPanel));
                table.getCellFormatter().getElement(row, 0).setId("expandCollapseCol");
                this.setRowStyle(row + 1, table, style, true);
            }
        }

        private void setRowStyle(int row, FlexTable table, String style, boolean isPanelRow) {
            table.getCellFormatter().setStyleName(row, 0, style);
            table.getCellFormatter().setStyleName(row, 1, style);
            if (!isPanelRow) {
                table.getCellFormatter().setStyleName(row, 2, style);
                table.getCellFormatter().setStyleName(row, 3, style);
            }
            table.getCellFormatter().getElement(row, 0).setId("noLinkExpandCollapseCol");
        }
    }
}

