/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn;

import ch.hortis.sonar.model.Snapshot;
import ch.hortis.sonar.mvn.CoreMojo;
import ch.hortis.sonar.service.SnapshotService;
import ch.hortis.sonar.service.WebInterfaceService;
import ch.hortis.sonar.service.WebInterfaceServiceImpl;
import java.io.File;
import java.io.IOException;
import javax.persistence.EntityManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class BatchLaunchMojo
extends CoreMojo {
    private String sonarHostURL;
    private WebInterfaceService webInterfaceService;

    public void setWebInterfaceService(WebInterfaceService webInterfaceService) {
        this.webInterfaceService = webInterfaceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.webInterfaceService == null) {
            this.webInterfaceService = new WebInterfaceServiceImpl(this.sonarHostURL);
        }
        EntityManager manager = this.getEntityManager();
        try {
            manager.getTransaction().begin();
            this.processSnapshots();
            manager.getTransaction().commit();
            Snapshot topLevel = this.getTopLevelSnapshot();
            if (topLevel == null) {
                throw new MojoExecutionException("Unable to find top level snapshot");
            }
            try {
                this.getLog().debug((CharSequence)("Firing root snapshot " + topLevel.getId()));
                this.webInterfaceService.triggerMeasuresCalculations(topLevel.getId());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error occured when triggering measures calculation job on remote server", (Exception)e);
            }
        }
        finally {
            if (manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            this.webInterfaceService = null;
            this.destroyManager();
        }
    }

    private Snapshot getTopLevelSnapshot() throws MojoExecutionException {
        SnapshotService service = new SnapshotService(this.getEntityManager());
        for (MavenProject reactorProject : this.getReactorProjects()) {
            Integer projectBoundSnapshotId = super.getSnapshotId(reactorProject);
            Snapshot projectBoundSnapshot = (Snapshot)this.getEntityManager().find(Snapshot.class, (Object)projectBoundSnapshotId);
            if (projectBoundSnapshot.getParent() != null || this.getReactorProjects().size() != 1 && service.getChildSnapshots(projectBoundSnapshot, false).size() <= 0) continue;
            return projectBoundSnapshot;
        }
        return null;
    }

    private void processSnapshots() throws MojoExecutionException {
        for (MavenProject reactorProject : this.getReactorProjects()) {
            this.processSnapshot(reactorProject, null);
        }
    }

    private void processSnapshot(MavenProject reactorProject, Snapshot parent) throws MojoExecutionException {
        Integer projectBoundSnapshotId = super.getSnapshotId(reactorProject);
        Snapshot projectBoundSnapshot = (Snapshot)this.getEntityManager().find(Snapshot.class, (Object)projectBoundSnapshotId);
        if (projectBoundSnapshot == null) {
            throw new MojoExecutionException("Unable to find Snapshot " + projectBoundSnapshotId + " bound to the pom");
        }
        if (parent != null) {
            projectBoundSnapshot.setParent(parent);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)(this.getSonarProjectId(projectBoundSnapshot.getMavenProject()) + "(" + projectBoundSnapshot.getId() + ") ->" + this.getSonarProjectId(parent.getMavenProject()) + " (" + parent.getId() + ")"));
            }
        }
        projectBoundSnapshot.setStatus("T");
        this.getEntityManager().merge((Object)projectBoundSnapshot);
        this.saveSnapshotHierarchyModules(projectBoundSnapshot, reactorProject);
    }

    private void saveSnapshotHierarchyModules(Snapshot snapshot, MavenProject reactorProject) throws MojoExecutionException {
        for (Object o : reactorProject.getModules()) {
            String moduleName = (String)o;
            File moduleFile = new File(reactorProject.getBasedir() + "/" + moduleName + "/pom.xml");
            MavenProject targetReactorProject = null;
            for (MavenProject project : this.getReactorProjects()) {
                try {
                    if (!project.getFile().getCanonicalFile().equals(moduleFile.getCanonicalFile())) continue;
                    targetReactorProject = project;
                    break;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to resolve canonical path of pom.xml", (Exception)e);
                }
            }
            if (targetReactorProject == null) {
                throw new MojoExecutionException("Unable to find module " + moduleName + " in reactor projects");
            }
            this.processSnapshot(targetReactorProject, snapshot);
        }
    }

    private String getSonarProjectId(ch.hortis.sonar.model.MavenProject project) {
        return project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getBranch();
    }
}

