/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.MavenProject;
import ch.hortis.sonar.model.MetricMeasure;
import ch.hortis.sonar.model.Snapshot;
import ch.hortis.sonar.model.WithFile;
import ch.hortis.sonar.mvn.CoreMojo;
import ch.hortis.sonar.mvn.Report;
import ch.hortis.sonar.mvn.mc.FilesRepository;
import ch.hortis.sonar.mvn.mc.FilesRepositoryImpl;
import ch.hortis.sonar.mvn.mc.MeasuresCollector;
import ch.hortis.sonar.service.MavenProjectService;
import ch.hortis.sonar.service.MetricService;
import ch.hortis.sonar.service.RulesService;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectMojo
extends CoreMojo {
    private FilesRepository filesRepository;

    public void setFilesRepository(FilesRepository filesRepository) {
        this.filesRepository = filesRepository;
    }

    protected List<Report> getTargetReports() {
        if (this.isLight().booleanValue()) {
            return Report.getLightReports();
        }
        return Report.getReports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        try {
            MavenProject sonarProject;
            MavenProjectService service = new MavenProjectService(this.getEntityManager());
            try {
                sonarProject = service.getMavenProject(this.getProject().getGroupId(), this.getProject().getArtifactId(), this.getBranch());
            }
            catch (NoResultException ex) {
                throw new MojoExecutionException("Unable to find project " + this.getProject().getGroupId() + ":" + this.getProject().getArtifactId() + ":" + this.getBranch() + " in database");
            }
            this.collect(sonarProject);
        }
        finally {
            this.destroyManager();
        }
    }

    private void collectAndPersist(Snapshot snapshot) throws MojoExecutionException {
        if (!this.getProject().getPackaging().equals("pom")) {
            if (this.filesRepository == null) {
                this.filesRepository = new FilesRepositoryImpl(this.getLog());
            }
            MetricService metricService = new MetricService(this.getEntityManager());
            RulesService rulesService = new RulesService(this.getEntityManager());
            for (Report report : this.getTargetReports()) {
                MeasuresCollector collector = report.getMeasuresCollector();
                if (!collector.initialize(this.getProject(), metricService, rulesService, this.filesRepository)) continue;
                List<Collectable> collected = collector.collect();
                this.persistCollectables(snapshot, collected);
            }
        }
    }

    private void collect(MavenProject sonarProject) throws MojoExecutionException {
        Snapshot snapshot = new Snapshot();
        snapshot.setCreatedAt(new Date());
        snapshot.setMavenProject(sonarProject);
        snapshot.setVersion(this.getProject().getVersion());
        this.getEntityManager().setFlushMode(FlushModeType.COMMIT);
        this.getEntityManager().getTransaction().begin();
        this.getEntityManager().persist((Object)snapshot);
        this.collectAndPersist(snapshot);
        this.setSnapshotId(snapshot.getId(), this.getProject());
        this.getEntityManager().getTransaction().commit();
    }

    private void persistCollectables(Snapshot snapshot, List<Collectable> collectables) throws MojoExecutionException {
        EntityManager manager = this.getEntityManager();
        for (Collectable collectable : collectables) {
            if (collectable instanceof WithFile) {
                if (((WithFile)collectable).getFile() == null) {
                    this.getLog().warn((CharSequence)("FileMeasure without file : " + collectable + ", snapshot=" + snapshot.getId()));
                    continue;
                }
                ((WithFile)collectable).getFile().setSnapshot(snapshot);
            }
            if (collectable instanceof MetricMeasure && ((MetricMeasure)collectable).getValue().isNaN()) {
                this.getLog().warn((CharSequence)("Measure with NaN value : " + collectable + ", snapshot=" + snapshot.getId()));
                continue;
            }
            collectable.setId(null);
            collectable.setSnapshot(snapshot);
            manager.persist((Object)collectable);
        }
    }
}

