/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.sonar.commons.database.DatabaseConfiguration;
import org.sonar.commons.database.DatabaseConnector;
import org.sonar.commons.database.DefaultDatabaseConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreMojo
extends AbstractMojo {
    private static final String SNAPSHOT_ID_PROP = "sonar.snaphsotId";
    private List<MavenProject> reactorProjects;
    private MavenProject mavenProject;
    private String jdbcURL;
    private String jdbcDriverClassName;
    private String jdbcUserName;
    private String jdbcPassword;
    private String branch;
    private Boolean light;
    private EntityManager manager = null;
    private DatabaseConnector databaseConnector = null;
    private boolean externalManager = false;

    protected void setManager(EntityManager manager) {
        this.externalManager = true;
        this.manager = manager;
    }

    protected EntityManager getEntityManager() {
        if (this.manager == null) {
            this.manager = this.getDatabaseConnector().createEntityManager();
        }
        return this.manager;
    }

    protected void destroyManager() {
        if (!this.externalManager && this.manager != null) {
            this.manager.clear();
            if (this.manager.isOpen()) {
                this.manager.close();
                this.manager = null;
            }
        }
    }

    protected void setReactorProjects(List<MavenProject> reactorProjects) {
        this.reactorProjects = reactorProjects;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected String getBranch() {
        return this.branch;
    }

    protected void setBranch(String branch) {
        this.branch = branch;
    }

    protected MavenProject getProject() {
        return this.mavenProject;
    }

    protected void setProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    protected void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    protected void setJdbcDriverClassName(String jdbcDriverClassName) {
        this.jdbcDriverClassName = jdbcDriverClassName;
    }

    protected void setJdbcUserName(String jdbcUserName) {
        this.jdbcUserName = jdbcUserName;
    }

    protected void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    protected void setLight(boolean light) {
        this.light = light;
    }

    protected Boolean isLight() {
        return this.light != null && this.light != false;
    }

    protected Integer getSnapshotId(MavenProject pom) {
        String propValue = (String)pom.getProperties().get(SNAPSHOT_ID_PROP);
        if (propValue == null) {
            throw new IllegalStateException("Unable to retreive property 'sonar.snaphsotId' from pom");
        }
        return new Integer(propValue);
    }

    protected void setSnapshotId(Integer id, MavenProject pom) {
        pom.getProperties().setProperty(SNAPSHOT_ID_PROP, id.toString());
    }

    protected DatabaseConnector getDatabaseConnector() {
        if (this.databaseConnector == null) {
            DatabaseConfiguration configuration = new DatabaseConfiguration(this.jdbcURL, this.jdbcDriverClassName, this.jdbcUserName, this.jdbcPassword);
            configuration.setIsolationLevel(2);
            configuration.setEnableCache(false);
            this.databaseConnector = new DefaultDatabaseConnector(configuration);
            this.databaseConnector.start();
        }
        return this.databaseConnector;
    }
}

