/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PomUtils {
    public static final String APACHE_MOJO_GROUP_ID = "org.apache.maven.plugins";
    public static final String CODEHAUS_MOJO_GROUP_ID = "org.codehaus.mojo";

    public static Plugin findBuildPlugin(MavenProject pom, String groupId, String artifactId) {
        if (pom != null && pom.getBuild() != null) {
            return PomUtils.getPlugin(pom.getBuild().getPlugins(), groupId, artifactId);
        }
        return null;
    }

    public static void copyPluginDependencies(MavenProject pom, Plugin plugin) {
        HashSet<String> depKeys = new HashSet<String>();
        Collection<Plugin> plugins = PomUtils.findPluginDefinitions(pom, plugin.getGroupId(), plugin.getArtifactId());
        for (Plugin pluginToCopy : plugins) {
            if (pluginToCopy.getDependencies() == null) continue;
            if (plugin.getDependencies() == null) {
                plugin.setDependencies(new ArrayList());
            }
            for (Dependency dependency : pluginToCopy.getDependencies()) {
                String depArtifactId = dependency.getArtifactId();
                if (depKeys.contains(depArtifactId)) continue;
                depKeys.add(depArtifactId);
                plugin.getDependencies().add(dependency);
            }
        }
    }

    public static Plugin findPlugin(MavenProject pom, String groupId, String artifactId) {
        Collection<Plugin> plugins = PomUtils.findPluginDefinitions(pom, groupId, artifactId);
        if (!plugins.isEmpty()) {
            return plugins.iterator().next();
        }
        return null;
    }

    public static Collection<Plugin> findPluginDefinitions(MavenProject pom, String groupId, String artifactId) {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        if (pom != null) {
            ReportPlugin reportPlugin;
            Plugin plugin;
            if (pom.getBuild() != null) {
                plugin = PomUtils.getPlugin(pom.getBuild().getPlugins(), groupId, artifactId);
                if (plugin != null) {
                    result.add(plugin);
                }
                if (pom.getBuild().getPluginManagement() != null && (plugin = PomUtils.getPlugin(pom.getBuild().getPluginManagement().getPlugins(), groupId, artifactId)) != null) {
                    result.add(plugin);
                }
            }
            if ((reportPlugin = PomUtils.findReportPlugin(pom, groupId, artifactId)) != null && (plugin = PomUtils.cloneReportPluginToPlugin(reportPlugin)) != null) {
                result.add(plugin);
            }
            if (pom.getParent() != null) {
                result.addAll(PomUtils.findPluginDefinitions(pom.getParent(), groupId, artifactId));
            }
        }
        return result;
    }

    public static Xpp3Dom findPluginConfiguration(MavenProject pom, String groupId, String artifactId) {
        Plugin plugin;
        Xpp3Dom configuration = null;
        if (pom.getBuild() != null && (plugin = PomUtils.getPlugin(pom.getBuild().getPlugins(), groupId, artifactId)) != null) {
            configuration = (Xpp3Dom)plugin.getConfiguration();
        }
        if (configuration == null && (plugin = PomUtils.findReportPlugin(pom, groupId, artifactId)) != null) {
            configuration = (Xpp3Dom)plugin.getConfiguration();
        }
        if (configuration == null && pom.getPluginManagement() != null && (plugin = PomUtils.getPlugin(pom.getPluginManagement().getPlugins(), groupId, artifactId)) != null) {
            configuration = (Xpp3Dom)plugin.getConfiguration();
        }
        if (configuration == null && pom.getParent() != null) {
            configuration = PomUtils.findPluginConfiguration(pom.getParent(), groupId, artifactId);
        }
        return configuration;
    }

    public static Plugin getPlugin(Collection<Plugin> plugins, String groupId, String artifactId) {
        Plugin result = null;
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                if (!PomUtils.isSamePlugin(plugin.getGroupId(), plugin.getArtifactId(), groupId, artifactId)) continue;
                result = plugin;
                break;
            }
        }
        return result;
    }

    protected static boolean isSamePlugin(String groupId1, String artifactId1, String groupId2, String artifactId2) {
        boolean same = false;
        if (artifactId1.equals(artifactId2)) {
            same = groupId1 == null ? groupId2 == null || groupId2.equals(APACHE_MOJO_GROUP_ID) || groupId2.equals(CODEHAUS_MOJO_GROUP_ID) : groupId1.equals(groupId2);
        }
        return same;
    }

    public static ReportPlugin findReportPlugin(MavenProject pom, String groupId, String artifactId) {
        ReportPlugin result = null;
        if (pom != null && pom.getReporting() != null && pom.getReporting().getPlugins() != null) {
            for (ReportPlugin plugin : pom.getReporting().getPlugins()) {
                if (!PomUtils.isSamePlugin(plugin.getGroupId(), plugin.getArtifactId(), groupId, artifactId)) continue;
                result = plugin;
                break;
            }
        }
        return result;
    }

    public static Xpp3Dom getConfiguration(Plugin plugin) {
        return (Xpp3Dom)plugin.getConfiguration();
    }

    public static String getConfigurationValue(Plugin plugin, String key) {
        Xpp3Dom node = PomUtils.getConfigurationNode(plugin, key);
        String value = null;
        if (node != null) {
            value = node.getValue();
        }
        return value;
    }

    public static Xpp3Dom getConfigurationNode(Plugin plugin, String key) {
        Xpp3Dom result = null;
        Xpp3Dom conf = PomUtils.getConfiguration(plugin);
        if (conf != null) {
            result = conf.getChild(key);
        }
        return result;
    }

    public static Plugin cloneReportPluginToPlugin(ReportPlugin reportPlugin) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        plugin.setVersion(reportPlugin.getVersion());
        plugin.setConfiguration(reportPlugin.getConfiguration());
        return plugin;
    }

    public static Collection<File> getJavaSourceFiles(MavenProject pom) {
        return PomUtils.getSourceFiles(pom, new String[]{"java"});
    }

    public static Collection<File> getJavaTestFiles(MavenProject pom) {
        return PomUtils.getTestFiles(pom, new String[]{"java"});
    }

    public static Collection<File> getSourceFiles(MavenProject pom, String[] extensions) {
        return PomUtils.getFilesFromDirectories(pom.getCompileSourceRoots(), extensions);
    }

    public static Collection<File> getTestFiles(MavenProject pom, String[] extensions) {
        return PomUtils.getFilesFromDirectories(pom.getTestCompileSourceRoots(), extensions);
    }

    public static Collection<File> getFilesFromDirectories(List<String> directories, String[] extensions) {
        ArrayList<File> result = new ArrayList<File>();
        if (directories != null) {
            for (String sourceDir : directories) {
                File dir = new File(sourceDir);
                if (!dir.exists()) continue;
                Collection files = FileUtils.listFiles((File)dir, (String[])extensions, (boolean)true);
                result.addAll(files);
            }
        }
        return result;
    }

    public static String getJavaVersion(MavenProject pom) {
        Xpp3Dom target;
        Xpp3Dom conf = PomUtils.findPluginConfiguration(pom, APACHE_MOJO_GROUP_ID, "maven-compiler-plugin");
        if (conf != null && (target = conf.getChild("target")) != null) {
            return target.getValue();
        }
        return null;
    }
}

