/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn;

import ch.hortis.sonar.mvn.MavenContext;
import ch.hortis.sonar.mvn.PomUtils;
import ch.hortis.sonar.mvn.Report;
import ch.hortis.sonar.mvn.reports.ReportHandler;
import ch.hortis.sonar.service.WebInterfaceService;
import ch.hortis.sonar.service.WebInterfaceServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepareMojo
extends AbstractMojo {
    private MavenProject mavenProject;
    private String sonarHostURL;
    private String sonarServerVersion;
    private Boolean light;
    private WebInterfaceService webInterfaceService;
    private MavenContext mavenContext;

    public void setWebInterfaceService(WebInterfaceService webInterfaceService) {
        this.webInterfaceService = webInterfaceService;
    }

    public MavenContext getMavenContext() {
        return this.mavenContext;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    protected List<Report> getTargetReports() {
        if (this.light != null && this.light.booleanValue()) {
            return Report.getLightReports();
        }
        return Report.getReports();
    }

    public void execute() throws MojoExecutionException {
        if (this.webInterfaceService == null) {
            this.webInterfaceService = new WebInterfaceServiceImpl(this.sonarHostURL);
        }
        this.mavenContext = new MavenContext(this.mavenProject, this.webInterfaceService, ((Object)((Object)this)).getClass().getClassLoader());
        this.preparePomForSonar();
        this.preparePomForRulesExtensions();
        this.preparePomForReports();
        this.generateGoals();
    }

    private void generateGoals() throws MojoExecutionException {
        boolean hasJavaSources = !PomUtils.getJavaSourceFiles(this.mavenProject).isEmpty();
        boolean hasJavaTests = !PomUtils.getJavaTestFiles(this.mavenProject).isEmpty();
        for (Report report : this.getTargetReports()) {
            ReportHandler reportHandler = report.getReportHandler();
            if (reportHandler == null || !hasJavaSources && !reportHandler.executeEvenIfNoJavaSources() || !hasJavaTests && !reportHandler.executeEvenIfNoJavaTests() || !reportHandler.execute(this.mavenContext, this.getLog())) continue;
            this.setReportGoals(reportHandler);
        }
    }

    private void setReportGoals(ReportHandler reportHandler) throws MojoExecutionException {
        for (String command : reportHandler.getCommands()) {
            String goals = this.mavenProject.getProperties().getProperty("sonar.bootstrap.additional.goals");
            if (goals == null) {
                goals = "";
            }
            goals = goals + command + "," + reportHandler.mustFailOnError() + ";";
            this.mavenProject.getProperties().setProperty("sonar.bootstrap.additional.goals", goals);
        }
    }

    private void preparePomForRulesExtensions() throws MojoExecutionException {
        try {
            Report rulesReport;
            if (this.webInterfaceService.hasCheckstyleRulesExtensions()) {
                rulesReport = Report.Checkstyle;
                this.addDependencyToPlugin(rulesReport.getGroupId(), rulesReport.getArtifactId(), rulesReport.getVersion(), "org.codehaus.sonar.extensions.runtime.rules", "checkstyle", "1.0-SNAPSHOT", "pom");
            }
            if (this.webInterfaceService.hasPmdRulesExtensions()) {
                rulesReport = Report.PMD;
                this.addDependencyToPlugin(rulesReport.getGroupId(), rulesReport.getArtifactId(), rulesReport.getVersion(), "org.codehaus.sonar.extensions.runtime.rules", "pmd", "1.0-SNAPSHOT", "pom");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to add rules extensions plugin", (Exception)e);
        }
    }

    private void addDependencyToPlugin(String pluginGroupId, String pluginArtifactId, String pluginVersion, String depGroupId, String depArtifactId, String depVersion, String dependencyType) throws MojoExecutionException {
        boolean pluginAlreadyDefined = true;
        Plugin plugin = PomUtils.findBuildPlugin(this.mavenProject, pluginGroupId, pluginArtifactId);
        if (plugin != null && pluginVersion != null && !pluginVersion.equals(plugin.getVersion())) {
            plugin = null;
        }
        if (plugin == null) {
            pluginAlreadyDefined = false;
            plugin = new Plugin();
            plugin.setGroupId(pluginGroupId);
            plugin.setArtifactId(pluginArtifactId);
            plugin.setVersion(pluginVersion);
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(depGroupId);
        dependency.setArtifactId(depArtifactId);
        dependency.setVersion(depVersion);
        dependency.setType(dependencyType);
        plugin.addDependency(dependency);
        if (!pluginAlreadyDefined) {
            this.mavenProject.getBuild().addPlugin(plugin);
        }
    }

    private void preparePomForReports() throws MojoExecutionException {
        File targetDir = new File(this.mavenProject.getBuild().getDirectory() + "/sonar");
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            throw new MojoExecutionException("Unable to created directory " + targetDir.getPath());
        }
        for (Report report : this.getTargetReports()) {
            ReportHandler reportHandler = report.getReportHandler();
            reportHandler.preparePom(this.mavenProject);
        }
        if (this.mavenProject.getReporting() != null) {
            this.mavenProject.getReporting().setPlugins(null);
        }
        if (this.mavenProject.getArtifact() != null && this.mavenProject.getArtifact().getVersionRange() == null) {
            this.getLog().warn((CharSequence)"Project has no version range");
            MavenProject parent = this.mavenProject;
            while (parent.getParent() != null) {
                if ((parent = parent.getParent()).getVersion() == null) continue;
                this.mavenProject.getArtifact().setVersionRange(VersionRange.createFromVersion((String)parent.getVersion()));
            }
            if (this.mavenProject.getArtifact().getVersionRange() == null) {
                this.getLog().warn((CharSequence)"Unable to define POM artifact version, please provide it in the project POM, forcing to version 1.0");
                this.mavenProject.getArtifact().setVersionRange(VersionRange.createFromVersion((String)"1.0"));
            } else {
                this.getLog().info((CharSequence)("Pom version set to " + this.mavenProject.getArtifact().getVersionRange()));
            }
        }
    }

    private void preparePomForSonar() throws MojoExecutionException {
        List repositories = this.mavenProject.getRepositories();
        for (Repository repository : repositories) {
            if (!repository.getId().equals("sonar")) continue;
            throw new MojoExecutionException("Pom already contains a repository with id 'sonar', please remove it");
        }
        Repository sonarRepository = new Repository();
        sonarRepository.setId("sonar");
        sonarRepository.setName("Sonar server maven repository");
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy();
        snapshotPolicy.setChecksumPolicy("ignore");
        snapshotPolicy.setEnabled(true);
        snapshotPolicy.setUpdatePolicy("always");
        sonarRepository.setSnapshots(snapshotPolicy);
        sonarRepository.setUrl(this.webInterfaceService.getSonarMavenRepository());
        repositories.add(sonarRepository);
        this.addDependencyToPlugin("org.codehaus.sonar", "sonar-core-maven-plugin", this.sonarServerVersion, "org.codehaus.sonar.extensions.runtime", "jdbc-driver", "1.0-SNAPSHOT", "jar");
    }

    protected void setLight(Boolean light) {
        this.light = light;
    }
}

