/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn;

import ch.hortis.sonar.model.ProjectLink;
import ch.hortis.sonar.mvn.CoreMojo;
import ch.hortis.sonar.service.MavenProjectService;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class ProjectMojo
extends CoreMojo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        EntityManager manager = this.getEntityManager();
        try {
            this.saveProjects(manager);
        }
        finally {
            if (manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            this.destroyManager();
        }
    }

    private void saveProjects(EntityManager manager) throws MojoExecutionException {
        manager.getTransaction().begin();
        for (MavenProject reactorProject : this.getReactorProjects()) {
            this.saveProject(reactorProject);
        }
        manager.getTransaction().commit();
    }

    private void saveProject(MavenProject mavenProject) throws MojoExecutionException {
        MavenProjectService service = new MavenProjectService(this.getEntityManager());
        try {
            ch.hortis.sonar.model.MavenProject sonarProject = service.getMavenProject(mavenProject.getGroupId(), mavenProject.getArtifactId(), this.getBranch());
            this.updateProject(sonarProject, mavenProject);
            this.getEntityManager().merge((Object)sonarProject);
        }
        catch (NoResultException e) {
            ch.hortis.sonar.model.MavenProject sonarProject = new ch.hortis.sonar.model.MavenProject();
            sonarProject.setArtifactId(mavenProject.getArtifactId());
            sonarProject.setGroupId(mavenProject.getGroupId());
            sonarProject.setBranch(this.getBranch());
            sonarProject.setEnabled(Boolean.valueOf(true));
            this.updateProject(sonarProject, mavenProject);
            this.getEntityManager().persist((Object)sonarProject);
        }
    }

    private void updateProject(ch.hortis.sonar.model.MavenProject sonarProject, MavenProject mavenProject) {
        sonarProject.setName(mavenProject.getName());
        sonarProject.setDescription(mavenProject.getDescription());
        this.updateProjectLink("homepage", mavenProject.getUrl(), sonarProject);
        Scm scmConfig = mavenProject.getScm();
        if (scmConfig == null) {
            scmConfig = new Scm();
        }
        this.updateProjectLink("scm", scmConfig.getUrl(), sonarProject);
        this.updateProjectLink("scm_dev", scmConfig.getDeveloperConnection(), sonarProject);
        this.updateProjectLink("scm_ro", scmConfig.getConnection(), sonarProject);
        CiManagement cimConfig = mavenProject.getCiManagement();
        if (cimConfig == null) {
            cimConfig = new CiManagement();
        }
        this.updateProjectLink("ci", cimConfig.getUrl(), sonarProject);
        IssueManagement imConfig = mavenProject.getIssueManagement();
        if (imConfig == null) {
            imConfig = new IssueManagement();
        }
        this.updateProjectLink("issue", imConfig.getUrl(), sonarProject);
    }

    private void updateProjectLink(String linkType, String href, ch.hortis.sonar.model.MavenProject sonarProject) {
        if (href != null && !"".equals(href)) {
            ProjectLink link = sonarProject.getProjectLinkByType(linkType);
            if (link == null) {
                link = new ProjectLink();
                link.setMavenProject(sonarProject);
                link.setType(linkType);
                sonarProject.getProjectLinks().add(link);
            }
            link.setHref(href);
        }
    }
}

