/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn;

import ch.hortis.sonar.mvn.mc.CPDCollector;
import ch.hortis.sonar.mvn.mc.CheckstyleCollector;
import ch.hortis.sonar.mvn.mc.CloverCollector;
import ch.hortis.sonar.mvn.mc.CoberturaCollector;
import ch.hortis.sonar.mvn.mc.JXRCollector;
import ch.hortis.sonar.mvn.mc.JavaNCSSCollector;
import ch.hortis.sonar.mvn.mc.MeasuresCollector;
import ch.hortis.sonar.mvn.mc.PMDCollector;
import ch.hortis.sonar.mvn.mc.SurefireCollector;
import ch.hortis.sonar.mvn.reports.CPDHandler;
import ch.hortis.sonar.mvn.reports.CheckstyleHandler;
import ch.hortis.sonar.mvn.reports.CloverHandler;
import ch.hortis.sonar.mvn.reports.CoberturaHandler;
import ch.hortis.sonar.mvn.reports.JXRHandler;
import ch.hortis.sonar.mvn.reports.JavaNCSSHandler;
import ch.hortis.sonar.mvn.reports.PMDHandler;
import ch.hortis.sonar.mvn.reports.ReportHandler;
import ch.hortis.sonar.mvn.reports.SurefireHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Report {
    JXR("org.apache.maven.plugins", "maven-jxr-plugin", "2.1", new JXRCollector(), new JXRHandler(), true, true),
    JavaNCSS("org.codehaus.mojo", "javancss-maven-plugin", "2.0-beta-2", new JavaNCSSCollector(), new JavaNCSSHandler(), true, true),
    Checkstyle("org.apache.maven.plugins", "maven-checkstyle-plugin", "2.1", new CheckstyleCollector(), new CheckstyleHandler(), true, true),
    PMD("org.apache.maven.plugins", "maven-pmd-plugin", "2.3", new PMDCollector(), new PMDHandler(), true, true),
    CPD("org.apache.maven.plugins", "maven-pmd-plugin", "2.3", new CPDCollector(), new CPDHandler(), true, true),
    Cobertura("org.codehaus.mojo", "cobertura-maven-plugin", "2.2", new CoberturaCollector(), new CoberturaHandler(), false, false),
    Clover("org.apache.maven.plugins", "maven-clover-plugin", "2.4", new CloverCollector(), new CloverHandler(), false, false),
    Surefire("org.apache.maven.plugins", "maven-surefire-plugin", "2.4.2", new SurefireCollector(), new SurefireHandler(), false, false);

    private String groupId;
    private String artifactId;
    private String version;
    private boolean includeInLightReport;
    private MeasuresCollector collector;
    private ReportHandler reportHandler;
    private boolean versionFixed;

    private Report(String groupId, String artifactId, String version, MeasuresCollector collector, ReportHandler reportHandler, boolean includeInLightReport, boolean versionFixed) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.collector = collector;
        this.reportHandler = reportHandler;
        if (this.reportHandler != null) {
            this.reportHandler.setReport(this);
        }
        this.includeInLightReport = includeInLightReport;
        this.versionFixed = versionFixed;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isIncludeInLightReport() {
        return this.includeInLightReport;
    }

    public boolean isVersionFixed() {
        return this.versionFixed;
    }

    public String toString() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public MeasuresCollector getMeasuresCollector() {
        return this.collector;
    }

    public ReportHandler getReportHandler() {
        return this.reportHandler;
    }

    private static List<Report> getReports(boolean includeInLightReport) {
        if (includeInLightReport) {
            ArrayList<Report> reports = new ArrayList<Report>();
            for (Report report : Report.getReports()) {
                if (!report.isIncludeInLightReport()) continue;
                reports.add(report);
            }
            return reports;
        }
        return Arrays.asList(Report.values());
    }

    public static List<Report> getReports() {
        return Report.getReports(false);
    }

    public static List<Report> getLightReports() {
        return Report.getReports(true);
    }
}

