/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.Metrics;
import ch.hortis.sonar.mvn.mc.FilesRepository;
import ch.hortis.sonar.mvn.mc.MeasuresCollector;
import ch.hortis.sonar.service.MetricService;
import ch.hortis.sonar.service.RulesService;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

public abstract class BaseMeasuresCollector
implements MeasuresCollector {
    protected DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.ENGLISH);
    protected final DecimalFormat sonarFormat = new DecimalFormat("#.###", this.dfs);
    protected MetricService metricService;
    protected RulesService rulesService;
    protected FilesRepository filesRepository;

    protected BaseMeasuresCollector() {
    }

    public final boolean initialize(MavenProject project, MetricService metricService, RulesService rulesService, FilesRepository filesRepository) {
        this.setMetricService(metricService);
        this.setRuleService(rulesService);
        this.setFilesRepository(filesRepository);
        return this.initialize(project);
    }

    public FilesRepository getFilesRepository() {
        return this.filesRepository;
    }

    public void setFilesRepository(FilesRepository filesRepository) {
        this.filesRepository = filesRepository;
    }

    protected abstract boolean initialize(MavenProject var1);

    public MetricService getMetricService() {
        return this.metricService;
    }

    public void setMetricService(MetricService metricService) {
        this.metricService = metricService;
    }

    public RulesService getRuleService() {
        return this.rulesService;
    }

    public void setRuleService(RulesService rulesService) {
        this.rulesService = rulesService;
    }

    public ch.hortis.sonar.model.File getFileFromClassName(String className) {
        String fileName = StringUtils.substringAfterLast((String)className, (String)".") + ".java";
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        return this.filesRepository.getFile(packageName, fileName);
    }

    public double parseNumber(String number, Locale locale) throws ParseException {
        if (number.equals("")) {
            return Double.NaN;
        }
        return NumberFormat.getNumberInstance(locale).parse(number).doubleValue();
    }

    public double parseNumber(String number) throws ParseException {
        return this.parseNumber(number, Locale.getDefault());
    }

    public double scaleValue(double value) {
        return this.scaleValue(value, 2);
    }

    public double scaleValue(double value, int decimals) {
        BigDecimal bd = new BigDecimal(value);
        return bd.setScale(decimals, RoundingMode.HALF_UP).doubleValue();
    }

    protected Metric loadMetric(Metrics metricsEnum) {
        if (this.getMetricService() != null) {
            return this.getMetricService().getMetric(metricsEnum.getName());
        }
        return null;
    }

    protected File findFileFromBuildDirectory(MavenProject project, String filename) {
        String xmlOutputDirectory = project.getBuild().getDirectory() + "/" + filename;
        File file = new File(xmlOutputDirectory);
        if (!file.exists()) {
            file = null;
        }
        return file;
    }
}

