/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.FileMeasure;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.Metrics;
import ch.hortis.sonar.model.ProjectMeasure;
import ch.hortis.sonar.mvn.mc.BaseMeasuresCollector;
import ch.hortis.sonar.mvn.mc.XmlParserException;
import ch.hortis.sonar.mvn.mc.XmlReportParser;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPDCollector
extends BaseMeasuresCollector {
    private Metric duplicationMetric;
    private Metric duplicatedLinesMetric;
    private Metric duplicatedTokensMetric;
    private XmlReportParser parser;
    private List sourcesDir;

    @Override
    public boolean initialize(MavenProject project) {
        File cpdFile = this.findFileFromBuildDirectory(project, "cpd.xml");
        boolean ok = false;
        if (cpdFile != null) {
            String xml = this.readXmlWithoutEncodingErrors(cpdFile);
            this.parser = new XmlReportParser();
            this.parser.parse(xml);
            this.sourcesDir = project.getCompileSourceRoots();
            this.duplicationMetric = this.loadMetric(Metrics.PMD_DUPLICATION);
            this.duplicatedLinesMetric = this.loadMetric(Metrics.PMD_DUPLICATED_LINES);
            this.duplicatedTokensMetric = this.loadMetric(Metrics.PMD_DUPLICATED_TOKENS);
            ok = true;
        }
        return ok;
    }

    @Override
    public List<Collectable> collect() throws MojoExecutionException {
        ArrayList<Collectable> result = new ArrayList<Collectable>();
        result.addAll(this.collectProjectMeasures());
        result.addAll(this.collectFileMeasures());
        return result;
    }

    protected String readXmlWithoutEncodingErrors(File file) {
        try {
            String xml = FileUtils.readFileToString((File)file);
            return this.removeCDataNodes(xml);
        }
        catch (IOException e) {
            throw new XmlParserException("can not read the file " + file.getAbsolutePath(), e);
        }
    }

    protected String removeCDataNodes(String xml) {
        String result = xml;
        String startNode = "<codefragment>";
        String endNode = "</codefragment>";
        String[] subs = StringUtils.substringsBetween((String)xml, (String)startNode, (String)endNode);
        if (subs != null) {
            for (String sub : subs) {
                result = StringUtils.remove((String)result, (String)(startNode + sub + endNode));
            }
        }
        return result;
    }

    protected List<ProjectMeasure> collectProjectMeasures() throws MojoExecutionException {
        NodeList duplications = this.parser.executeXPathNodeList("/pmd-cpd/duplication");
        CPDReportDataContainer projectContainer = new CPDReportDataContainer();
        for (int i = 0; i < duplications.getLength(); ++i) {
            Node duplication = duplications.item(i);
            Number lines = (Number)this.parser.executeXPath(duplication, XPathConstants.NUMBER, "@lines");
            Number tokens = (Number)this.parser.executeXPath(duplication, XPathConstants.NUMBER, "@tokens");
            projectContainer.cumulate(1, lines, tokens);
        }
        return projectContainer.asMeasures();
    }

    public List<FileMeasure> collectFileMeasures() throws MojoExecutionException {
        ArrayList<FileMeasure> result = new ArrayList<FileMeasure>();
        NodeList duplications = this.parser.executeXPathNodeList("/pmd-cpd/duplication");
        HashMap<String, CPDFileReportDataContainer> fileContainer = new HashMap<String, CPDFileReportDataContainer>();
        for (int i = 0; i < duplications.getLength(); ++i) {
            Element duplication = (Element)duplications.item(i);
            NodeList files = this.parser.executeXPathNodeList(duplication, "file");
            this.processFileMeasure(fileContainer, (Element)files.item(0), duplication);
            this.processFileMeasure(fileContainer, (Element)files.item(1), duplication);
        }
        for (CPDFileReportDataContainer data : fileContainer.values()) {
            result.addAll(data.asMeasures());
        }
        return result;
    }

    private void processFileMeasure(Map<String, CPDFileReportDataContainer> fileContainer, Element fileEl, Element duplication) throws MojoExecutionException {
        String filePath = fileEl.getAttribute("path").replace('\\', '/');
        String fileName = StringUtils.substringAfterLast((String)filePath, (String)"/");
        String packageName = StringUtils.substringBeforeLast((String)filePath, (String)"/");
        if (this.sourcesDir != null) {
            Iterator srcItr = this.sourcesDir.iterator();
            while (srcItr.hasNext()) {
                String sourceDir = ((String)srcItr.next()).replace('\\', '/');
                if (!packageName.startsWith(sourceDir) && !packageName.contains(sourceDir)) continue;
                if (!sourceDir.endsWith("/")) {
                    sourceDir = sourceDir + "/";
                }
                packageName = StringUtils.substringAfter((String)packageName, (String)sourceDir).replace('/', '.');
                CPDFileReportDataContainer data = fileContainer.get((packageName = packageName.replace('/', '.')) + fileName);
                if (data == null) {
                    ch.hortis.sonar.model.File file = this.getFilesRepository().getFile(packageName, fileName);
                    if (file == null) {
                        throw new MojoExecutionException("Unable to find file '" + fileName + "' in package '" + packageName + "'");
                    }
                    data = new CPDFileReportDataContainer(file);
                    fileContainer.put(packageName + fileName, data);
                }
                try {
                    data.cumulate(1, this.parseNumber(duplication.getAttribute("lines")), this.parseNumber(duplication.getAttribute("tokens")));
                }
                catch (ParseException e) {
                    throw new MojoExecutionException("Number parsing exception", (Exception)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CPDFileReportDataContainer
    extends CPDReportDataContainer {
        private ch.hortis.sonar.model.File file;

        private CPDFileReportDataContainer(ch.hortis.sonar.model.File file) {
            this.file = file;
        }

        private Collection<FileMeasure> asMeasures() {
            ArrayList<FileMeasure> measures = new ArrayList<FileMeasure>();
            FileMeasure measure = new FileMeasure();
            measure.setMetric(CPDCollector.this.duplicationMetric);
            measure.setFile(this.file);
            measure.setValue(Double.valueOf(this.duplication));
            measures.add(measure);
            measure = new FileMeasure();
            measure.setMetric(CPDCollector.this.duplicatedLinesMetric);
            measure.setFile(this.file);
            measure.setValue(Double.valueOf(this.duplicatedLines));
            measures.add(measure);
            measure = new FileMeasure();
            measure.setMetric(CPDCollector.this.duplicatedTokensMetric);
            measure.setFile(this.file);
            measure.setValue(Double.valueOf(this.duplicatedTokens));
            measures.add(measure);
            return measures;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CPDReportDataContainer {
        protected double duplication;
        protected double duplicatedLines;
        protected double duplicatedTokens;

        private CPDReportDataContainer() {
        }

        protected void cumulate(Number duplication, Number duplicatedLines, Number duplicatedTokens) {
            this.duplication += duplication.doubleValue();
            this.duplicatedLines += duplicatedLines.doubleValue();
            this.duplicatedTokens += duplicatedTokens.doubleValue();
        }

        private List<ProjectMeasure> asMeasures() {
            ArrayList<ProjectMeasure> measures = new ArrayList<ProjectMeasure>();
            ProjectMeasure measure = new ProjectMeasure();
            measure.setMetric(CPDCollector.this.duplicationMetric);
            measure.setValue(Double.valueOf(this.duplication));
            measures.add(measure);
            measure = new ProjectMeasure();
            measure.setMetric(CPDCollector.this.duplicatedLinesMetric);
            measure.setValue(Double.valueOf(this.duplicatedLines));
            measures.add(measure);
            measure = new ProjectMeasure();
            measure.setMetric(CPDCollector.this.duplicatedTokensMetric);
            measure.setValue(Double.valueOf(this.duplicatedTokens));
            measures.add(measure);
            return measures;
        }
    }
}

