/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.RuleFailure;
import ch.hortis.sonar.model.RuleFailureLevel;
import ch.hortis.sonar.mvn.mc.BaseMeasuresCollector;
import ch.hortis.sonar.mvn.mc.XmlReportParser;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckstyleCollector
extends BaseMeasuresCollector {
    private XmlReportParser reportParser = null;
    private List<String> sourceDirs = null;

    @Override
    public boolean initialize(MavenProject project) {
        File report = this.findFileFromBuildDirectory(project, "checkstyle-result.xml");
        boolean ok = false;
        if (report != null) {
            ok = true;
            this.sourceDirs = project.getCompileSourceRoots();
            this.reportParser = new XmlReportParser();
            this.reportParser.parse(report);
        }
        return ok;
    }

    @Override
    public List<Collectable> collect() throws MojoExecutionException {
        return this.collectRuleFailures();
    }

    public List<Collectable> collectRuleFailures() throws MojoExecutionException {
        ArrayList<Collectable> collectables = new ArrayList<Collectable>(4096);
        NodeList files = this.reportParser.executeXPathNodeList("/checkstyle/file");
        if (files != null) {
            for (int i = 0; i < files.getLength(); ++i) {
                Element element = (Element)files.item(i);
                String checkstyleName = element.getAttribute("name");
                List<Element> errors = this.reportParser.getChildElements(element, "error");
                for (Element error : errors) {
                    String source = error.getAttribute("source");
                    if (this.rulesService.getRuleByPluginKey(source) == null) continue;
                    RuleFailure failure = new RuleFailure();
                    collectables.add((Collectable)failure);
                    failure.setRule(this.rulesService.getRuleByPluginKey(source));
                    failure.setFile(this.getFile(checkstyleName));
                    failure.setMessage(error.getAttribute("message"));
                    try {
                        String column;
                        String line = error.getAttribute("line");
                        if (line != null && !"".equals(line)) {
                            failure.addParameter("line", Double.valueOf(this.parseNumber(line)));
                        }
                        if ((column = error.getAttribute("column")) != null && !"".equals(column)) {
                            failure.addParameter("column", Double.valueOf(this.parseNumber(column)));
                        }
                    }
                    catch (ParseException ex) {
                        throw new MojoExecutionException("ParseException during Checkstyle report parsing", (Exception)ex);
                    }
                    String severity = error.getAttribute("severity");
                    if ("error".equals(severity)) {
                        failure.setLevel(RuleFailureLevel.ERROR);
                        continue;
                    }
                    if ("warning".equals(severity)) {
                        failure.setLevel(RuleFailureLevel.WARNING);
                        continue;
                    }
                    failure.setLevel(RuleFailureLevel.INFO);
                }
            }
        }
        return collectables;
    }

    private ch.hortis.sonar.model.File getFile(String checkstyleFilename) {
        checkstyleFilename = checkstyleFilename.replace('\\', '/');
        String filename = StringUtils.substringAfterLast((String)checkstyleFilename, (String)"/");
        String namespace = StringUtils.substringBeforeLast((String)checkstyleFilename, (String)filename);
        for (String sourceDir : this.sourceDirs) {
            if (!(sourceDir = sourceDir.replace('\\', '/')).endsWith("/")) {
                sourceDir = sourceDir + "/";
            }
            if (!namespace.startsWith(sourceDir) && !namespace.contains(sourceDir)) continue;
            if (!(namespace = StringUtils.substringAfter((String)namespace, (String)sourceDir).replace('/', '.')).endsWith(".")) break;
            namespace = StringUtils.chop((String)namespace);
            break;
        }
        return this.getFilesRepository().getFile(namespace, filename);
    }
}

