/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.FileMeasure;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.Metrics;
import ch.hortis.sonar.model.ProjectMeasure;
import ch.hortis.sonar.mvn.mc.BaseMeasuresCollector;
import ch.hortis.sonar.mvn.mc.XmlReportParser;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverCollector
extends BaseMeasuresCollector {
    protected XmlReportParser parser;
    protected Metric cloverMetric;

    @Override
    public boolean initialize(MavenProject project) {
        File report = this.findFileFromBuildDirectory(project, "site/clover/clover.xml");
        if (report != null) {
            this.parser = new XmlReportParser();
            this.parser.parse(report);
            this.cloverMetric = this.loadMetric(Metrics.CLOVER_COVERAGE);
            return true;
        }
        return false;
    }

    @Override
    public List<Collectable> collect() throws MojoExecutionException {
        ArrayList<Collectable> result = new ArrayList<Collectable>();
        try {
            result.addAll(this.collectProjectMeasures());
            result.addAll(this.collectFileMeasures());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error during Clover reports parsing", ex);
        }
        return result;
    }

    public List<ProjectMeasure> collectProjectMeasures() throws ParseException {
        Element projectEl = this.parser.getChildElement(this.parser.getRoot(), "project");
        Element metricsEl = this.parser.getChildElement(projectEl, "metrics");
        ProjectMeasure measure = new ProjectMeasure();
        measure.setMetric(this.cloverMetric);
        measure.setValue(this.getCodeCoverageFromMetricsNode(metricsEl));
        ArrayList<ProjectMeasure> measures = new ArrayList<ProjectMeasure>();
        measures.add(measure);
        return measures;
    }

    public List<FileMeasure> collectFileMeasures() throws MojoExecutionException, ParseException {
        ArrayList<FileMeasure> measures = new ArrayList<FileMeasure>();
        NodeList packages = this.parser.executeXPathNodeList("/coverage/project/package");
        for (int i = 0; i < packages.getLength(); ++i) {
            Element pkElt = (Element)packages.item(i);
            String namespace = pkElt.getAttribute("name");
            NodeList files = this.parser.executeXPathNodeList(pkElt, "file");
            for (int j = 0; j < files.getLength(); ++j) {
                Element fileElt = (Element)files.item(j);
                String filename = this.extractFilename(fileElt);
                FileMeasure measure = new FileMeasure();
                ch.hortis.sonar.model.File file = this.getFilesRepository().getFile(namespace, filename);
                if (file == null) {
                    throw new MojoExecutionException("Unable to find file '" + filename + "' in package '" + namespace + "'");
                }
                measure.setFile(file);
                measure.setMetric(this.cloverMetric);
                Element metricsElt = (Element)this.parser.executeXPath(fileElt, XPathConstants.NODE, "metrics");
                if (!this.canBeIncludedInFileMetrics(metricsElt)) continue;
                measure.setValue(this.getCodeCoverageFromMetricsNode(metricsElt));
                measures.add(measure);
            }
        }
        return measures;
    }

    private String extractFilename(Element fileElt) {
        String filename = fileElt.getAttribute("name");
        filename = StringUtils.replaceChars((String)filename, (char)'\\', (char)'/');
        filename = StringUtils.substringAfterLast((String)filename, (String)"/");
        return filename;
    }

    private boolean canBeIncludedInFileMetrics(Element metricsNode) throws ParseException {
        return this.parseNumber(metricsNode.getAttribute("elements")) > 0.0;
    }

    private Double getCodeCoverageFromMetricsNode(Element metricsNode) throws ParseException {
        double coveredElements = this.parseNumber(metricsNode.getAttribute("coveredelements"));
        double nb = this.parseNumber(metricsNode.getAttribute("elements"));
        return 100.0 * (coveredElements / nb);
    }
}

