/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.FileMeasure;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.Metrics;
import ch.hortis.sonar.model.ProjectMeasure;
import ch.hortis.sonar.mvn.mc.BaseMeasuresCollector;
import ch.hortis.sonar.mvn.mc.XmlReportParser;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoberturaCollector
extends BaseMeasuresCollector {
    private XmlReportParser parser;
    private Metric lineCoverageMetric;
    private Metric branchCoverageMetric;

    @Override
    public boolean initialize(MavenProject project) {
        File reportFile = this.findFileFromBuildDirectory(project, "site/cobertura/coverage.xml");
        boolean ok = false;
        if (reportFile != null) {
            ok = true;
            this.parser = new XmlReportParser();
            this.parser.parse(reportFile);
            this.lineCoverageMetric = this.loadMetric(Metrics.COBERTURA_LINE_COVERAGE);
            this.branchCoverageMetric = this.loadMetric(Metrics.COBERTURA_BRANCH_COVERAGE);
        }
        return ok;
    }

    @Override
    public List<Collectable> collect() throws MojoExecutionException {
        ArrayList<Collectable> result = new ArrayList<Collectable>();
        result.addAll(this.collectProjectMeasures());
        result.addAll(this.collectFileMeasures());
        return result;
    }

    public List<ProjectMeasure> collectProjectMeasures() throws MojoExecutionException {
        ArrayList<ProjectMeasure> measures = new ArrayList<ProjectMeasure>();
        try {
            double lineRate = this.parseNumber(this.parser.executeXPath("/coverage/@line-rate"), Locale.ENGLISH);
            measures.add(new ProjectMeasure(this.lineCoverageMetric, Double.valueOf(this.convertPercentage(lineRate))));
            double branchRate = this.parseNumber(this.parser.executeXPath("/coverage/@branch-rate"), Locale.ENGLISH);
            measures.add(new ProjectMeasure(this.branchCoverageMetric, Double.valueOf(this.convertPercentage(branchRate))));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error during Cobertura reports parsing", ex);
        }
        return measures;
    }

    public List<FileMeasure> collectFileMeasures() throws MojoExecutionException {
        ArrayList<FileMeasure> measures = new ArrayList<FileMeasure>();
        NodeList classes = this.parser.executeXPathNodeList("//classes/class");
        for (int i = 0; i < classes.getLength(); ++i) {
            FileMeasure branchMeasure;
            Element elt = (Element)classes.item(i);
            FileMeasure lineMeasure = this.toFileMeasure(elt, this.lineCoverageMetric, "line-rate");
            if (lineMeasure != null) {
                measures.add(lineMeasure);
            }
            if ((branchMeasure = this.toFileMeasure(elt, this.branchCoverageMetric, "branch-rate")) == null) continue;
            measures.add(branchMeasure);
        }
        return measures;
    }

    protected FileMeasure toFileMeasure(Element elt, Metric metric, String valueAttributeName) throws MojoExecutionException {
        String name = elt.getAttribute("filename");
        name = StringUtils.replaceChars((String)name, (char)'\\', (char)'/');
        String filename = StringUtils.substringAfterLast((String)name, (String)"/");
        String namespace = StringUtils.substringBeforeLast((String)name, (String)("/" + filename));
        namespace = StringUtils.replaceChars((String)namespace, (char)'/', (char)'.');
        ch.hortis.sonar.model.File file = this.getFilesRepository().getFile(namespace, filename);
        if (file == null) {
            return null;
        }
        FileMeasure measure = new FileMeasure();
        measure.setMetric(null);
        measure.setFile(file);
        measure.setMetric(metric);
        try {
            measure.setValue(Double.valueOf(this.convertPercentage(this.parseNumber(elt.getAttribute(valueAttributeName), Locale.ENGLISH))));
            return measure;
        }
        catch (ParseException ex) {
            throw new MojoExecutionException("ParseException during Cobertura report parsing", (Exception)ex);
        }
    }

    protected double convertPercentage(Number percentage) {
        return this.scaleValue(percentage.doubleValue() * 100.0);
    }
}

