/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.FileSource;
import ch.hortis.sonar.model.FileType;
import ch.hortis.sonar.mvn.mc.BaseMeasuresCollector;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXRCollector
extends BaseMeasuresCollector {
    private static final List<String> JXR_PROPRIETARY_FILENAMES = JXRCollector.getJXRProprietaryFilenames();
    private File classesFile;
    private File testClassesFile;
    private JXRFilesFilter filter;

    @Override
    protected boolean initialize(MavenProject project) {
        this.classesFile = this.findClassesFile(project, "/site/xref");
        this.testClassesFile = this.findClassesFile(project, "/site/xref-test");
        this.filter = new JXRFilesFilter();
        return this.classesFile != null || this.testClassesFile != null;
    }

    @Override
    public List<Collectable> collect() throws MojoExecutionException {
        ArrayList<Collectable> collectables = new ArrayList<Collectable>();
        if (this.classesFile != null) {
            collectables.addAll(this.collectFiles(this.classesFile, FileType.MAIN));
        }
        if (this.testClassesFile != null) {
            collectables.addAll(this.collectFiles(this.testClassesFile, FileType.UNIT_TEST));
        }
        return collectables;
    }

    private List<Collectable> collectFiles(File allClassesFile, FileType fileType) throws MojoExecutionException {
        String rootJXRDirectoryPath;
        File jxrDirectory = allClassesFile.getParentFile();
        try {
            rootJXRDirectoryPath = jxrDirectory.getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to retreive JXR root directory canonical path", (Exception)e);
        }
        return this.walkDirectory(jxrDirectory, rootJXRDirectoryPath, fileType);
    }

    private List<Collectable> walkDirectory(File jxrDirectory, String rootJxrDirectoryPath, FileType fileType) throws MojoExecutionException {
        ArrayList<Collectable> result = new ArrayList<Collectable>();
        File[] jxrDirContent = jxrDirectory.listFiles(this.filter);
        if (jxrDirContent != null) {
            for (File file : jxrDirContent) {
                if (file.isDirectory()) {
                    result.addAll(this.walkDirectory(file, rootJxrDirectoryPath, fileType));
                    continue;
                }
                ch.hortis.sonar.model.File jxrSource = this.toFile(file, rootJxrDirectoryPath, fileType);
                result.add((Collectable)jxrSource);
                this.filesRepository.addFile(jxrSource);
            }
        }
        return result;
    }

    private File findClassesFile(MavenProject project, String base) {
        String xhtmlFile = project.getBuild().getDirectory() + base + "/allclasses-frame.html";
        File result = new File(xhtmlFile);
        return result.exists() ? result : null;
    }

    private ch.hortis.sonar.model.File toFile(File jxrSourceFile, String rootJXRDirectoryPath, FileType fileType) throws MojoExecutionException {
        String source;
        String path;
        try {
            path = jxrSourceFile.getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to retreive file canonical path", (Exception)e);
        }
        String filename = StringUtils.substringAfterLast((String)path, (String)"/");
        filename = StringUtils.replaceOnce((String)filename, (String)".html", (String)".java");
        String namespace = StringUtils.removeStart((String)path, (String)rootJXRDirectoryPath);
        namespace = StringUtils.substringBeforeLast((String)namespace, (String)"/");
        namespace = StringUtils.replaceChars((String)namespace, (char)'/', (char)'.');
        if (namespace.endsWith(".")) {
            namespace = StringUtils.chop((String)namespace);
        }
        if (namespace.startsWith(".")) {
            namespace = StringUtils.substringAfter((String)namespace, (String)".");
        }
        ch.hortis.sonar.model.File file = new ch.hortis.sonar.model.File(filename, namespace, null);
        file.setType(fileType);
        try {
            source = FileUtils.readFileToString((File)jxrSourceFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO error during file " + jxrSourceFile.getPath() + " reading", (Exception)e);
        }
        FileSource fileSource = new FileSource(source);
        fileSource.setFile(file);
        file.setFileSource(fileSource);
        return file;
    }

    private static List<String> getJXRProprietaryFilenames() {
        ArrayList<String> filenames = new ArrayList<String>();
        filenames.add("index.html");
        filenames.add("allclasses-frame.html");
        filenames.add("overview-frame.html");
        filenames.add("overview-summary.html");
        filenames.add("package-frame.html");
        filenames.add("package-summary.html");
        return filenames;
    }

    private class JXRFilesFilter
    implements FileFilter {
        private JXRFilesFilter() {
        }

        public boolean accept(File pathname) {
            String filenname = pathname.getName();
            return pathname.isDirectory() || filenname.endsWith(".html") && !JXR_PROPRIETARY_FILENAMES.contains(filenname);
        }
    }
}

