/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.FileMeasure;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.Metrics;
import ch.hortis.sonar.model.ProjectMeasure;
import ch.hortis.sonar.mvn.mc.BaseMeasuresCollector;
import ch.hortis.sonar.mvn.mc.XmlReportParser;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaNCSSCollector
extends BaseMeasuresCollector {
    protected XmlReportParser reportParser;
    protected Metric packageMetric;
    protected Metric ncssMetric;
    protected Metric complexityMetric;
    protected Metric classesMetric;
    protected Metric functionsMetric;

    @Override
    public boolean initialize(MavenProject project) {
        File reportFile = this.findFileFromBuildDirectory(project, "javancss-raw-report.xml");
        if (reportFile != null) {
            this.reportParser = new XmlReportParser();
            this.reportParser.parse(reportFile);
            this.packageMetric = this.loadMetric(Metrics.NCSS_PACKAGES);
            this.ncssMetric = this.loadMetric(Metrics.NCSS_NCSS);
            this.complexityMetric = this.loadMetric(Metrics.CYCLOMATIC_COMPLEXITY);
            this.classesMetric = this.loadMetric(Metrics.NCSS_CLASSES);
            this.functionsMetric = this.loadMetric(Metrics.NCSS_FUNCTIONS);
            return true;
        }
        return false;
    }

    @Override
    public List<Collectable> collect() throws MojoExecutionException {
        ArrayList<Collectable> result = new ArrayList<Collectable>();
        result.addAll(this.collectProjectMeasures());
        result.addAll(this.collectFileMeasures());
        return result;
    }

    public List<ProjectMeasure> collectProjectMeasures() throws MojoExecutionException {
        ArrayList<ProjectMeasure> measures = new ArrayList<ProjectMeasure>();
        try {
            measures.add(new ProjectMeasure(this.packageMetric, Double.valueOf(this.parseNumber(this.reportParser.executeXPath("count(/javancss/packages/package)")))));
            measures.add(new ProjectMeasure(this.ncssMetric, Double.valueOf(this.parseNumber(this.reportParser.executeXPath("sum(/javancss/objects/object/ncss/text())")))));
            measures.add(new ProjectMeasure(this.complexityMetric, Double.valueOf(this.parseNumber(this.reportParser.executeXPath("sum(/javancss/functions/function/ccn/text())")))));
            measures.add(new ProjectMeasure(this.classesMetric, Double.valueOf(this.parseNumber(this.reportParser.executeXPath("/javancss/packages/total/classes")))));
            measures.add(new ProjectMeasure(this.functionsMetric, Double.valueOf(this.parseNumber(this.reportParser.executeXPath("/javancss/packages/total/functions")))));
        }
        catch (ParseException ex) {
            throw new MojoExecutionException("ParseException during JavaNCSS report parsing", (Exception)ex);
        }
        return measures;
    }

    public List<FileMeasure> collectFileMeasures() throws MojoExecutionException {
        try {
            ArrayList<FileMeasure> measures = new ArrayList<FileMeasure>();
            NodeList classes = this.reportParser.executeXPathNodeList("/javancss/objects/object");
            if (classes != null) {
                for (int i = 0; i < classes.getLength(); ++i) {
                    Element element = (Element)classes.item(i);
                    String className = this.reportParser.getChildElementValue(element, "name");
                    ch.hortis.sonar.model.File file = this.getFileFromClassName(className);
                    this.addFileMeasure(measures, file, element, "ncss", this.ncssMetric);
                    this.addFileMeasure(measures, file, element, "functions", this.functionsMetric);
                    this.addFileMeasure(measures, file, 1.0, this.classesMetric);
                }
            }
            this.ccnFileMeasures(measures);
            return measures;
        }
        catch (ParseException ex) {
            throw new MojoExecutionException("ParseException during JavaNCSS report parsing", (Exception)ex);
        }
    }

    private void ccnFileMeasures(ArrayList<FileMeasure> measures) throws MojoExecutionException, ParseException {
        NodeList functions = this.reportParser.executeXPathNodeList("/javancss/functions/function");
        HashMap<String, Integer> ccnCountperClass = new HashMap<String, Integer>();
        if (functions != null) {
            for (int i = 0; i < functions.getLength(); ++i) {
                Element element = (Element)functions.item(i);
                String functionName = this.reportParser.getChildElementValue(element, "name");
                Integer ccnForFunction = new Integer(this.reportParser.getChildElementValue(element, "ccn"));
                String className = this.getClassNameForFunction(functionName);
                Integer ccnSum = (Integer)ccnCountperClass.get(className);
                if (ccnSum == null) {
                    ccnSum = 0;
                }
                ccnSum = ccnSum + ccnForFunction;
                ccnCountperClass.put(className, ccnSum);
            }
        }
        for (String className : ccnCountperClass.keySet()) {
            Integer ccnForClass = (Integer)ccnCountperClass.get(className);
            ch.hortis.sonar.model.File file = this.getFileFromClassName(className);
            this.addFileMeasure(measures, file, ccnForClass.doubleValue(), this.complexityMetric);
        }
    }

    protected String getClassNameForFunction(String functionName) {
        String className = StringUtils.substringBeforeLast((String)functionName, (String)".");
        return this.getClassName(className);
    }

    private String getClassName(String classNameCandidate) {
        String[] packages;
        int lastPointIndex = classNameCandidate.lastIndexOf(".");
        if (lastPointIndex == -1) {
            return classNameCandidate;
        }
        String packageName = StringUtils.substringBeforeLast((String)classNameCandidate, (String)".");
        String className = StringUtils.substringAfterLast((String)classNameCandidate, (String)".");
        for (String pack : packages = StringUtils.split((String)packageName, (char)'.')) {
            if (this.isPackageName(pack)) continue;
            return this.getClassName(packageName);
        }
        return packageName + "." + className;
    }

    protected boolean isPackageName(String classNameCandidate) {
        if (!Character.isLowerCase(classNameCandidate.charAt(0))) {
            return false;
        }
        for (int i = 0; i < classNameCandidate.length(); ++i) {
            char currentLetter = classNameCandidate.charAt(i);
            if (Character.isLetterOrDigit(currentLetter)) continue;
            return false;
        }
        return true;
    }

    private void addFileMeasure(ArrayList<FileMeasure> measures, ch.hortis.sonar.model.File file, Element classElement, String key, Metric metric) throws ParseException {
        Element element = this.reportParser.getChildElement(classElement, key);
        if (element != null && element.getFirstChild() != null && element.getFirstChild().getNodeValue() != null) {
            String value = element.getFirstChild().getNodeValue();
            this.addFileMeasure(measures, file, this.parseNumber(value), metric);
        }
    }

    private void addFileMeasure(ArrayList<FileMeasure> measures, ch.hortis.sonar.model.File file, Double value, Metric metric) throws ParseException {
        FileMeasure fileMeasure = new FileMeasure();
        fileMeasure.setFile(file);
        fileMeasure.setValue(value);
        fileMeasure.setMetric(metric);
        measures.add(fileMeasure);
    }
}

