/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.Rule;
import ch.hortis.sonar.model.RuleFailure;
import ch.hortis.sonar.model.RuleFailureLevel;
import ch.hortis.sonar.mvn.mc.BaseMeasuresCollector;
import ch.hortis.sonar.mvn.mc.XmlReportParser;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMDCollector
extends BaseMeasuresCollector {
    private File pmdFile = null;
    private XmlReportParser parser = null;

    @Override
    public boolean initialize(MavenProject project) {
        this.pmdFile = this.findFileFromBuildDirectory(project, "pmd.xml");
        boolean ok = false;
        if (this.pmdFile != null) {
            this.parser = new XmlReportParser();
            this.parser.parse(this.pmdFile);
            ok = true;
        }
        return ok;
    }

    @Override
    public List<Collectable> collect() throws MojoExecutionException {
        return this.collectRuleFailures();
    }

    public List<Collectable> collectRuleFailures() throws MojoExecutionException {
        ArrayList<Collectable> collectables = new ArrayList<Collectable>();
        if (this.pmdFile != null) {
            NodeList files = this.parser.executeXPathNodeList("/pmd/file");
            for (int i = 0; i < files.getLength(); ++i) {
                Element element = (Element)files.item(i);
                String name = element.getAttribute("name");
                String filename = StringUtils.substringAfterLast((String)name, (String)"/");
                if (filename == null || "".equals(filename)) {
                    filename = StringUtils.substringAfterLast((String)name, (String)"\\");
                }
                List<Element> violations = this.parser.getChildElements(element, "violation");
                for (Element violation : violations) {
                    Rule rule = this.getRuleService().getRuleByPluginKey(violation.getAttribute("rule"));
                    if (rule == null) continue;
                    RuleFailure failure = new RuleFailure();
                    collectables.add((Collectable)failure);
                    failure.setRule(rule);
                    ch.hortis.sonar.model.File file = this.getFilesRepository().getFile(violation.getAttribute("package"), filename);
                    failure.setFile(file);
                    String line = violation.getAttribute("beginline");
                    if (line != null && !"".equals(line)) {
                        failure.addParameter("line", Double.valueOf(line));
                    }
                    failure.setMessage(violation.getFirstChild().getNodeValue());
                    int priority = Integer.parseInt(violation.getAttribute("priority"));
                    if (priority <= 2) {
                        failure.setLevel(RuleFailureLevel.ERROR);
                        continue;
                    }
                    if (priority == 3 || priority == 4) {
                        failure.setLevel(RuleFailureLevel.WARNING);
                        continue;
                    }
                    failure.setLevel(RuleFailureLevel.INFO);
                }
            }
        }
        return collectables;
    }
}

