/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.model.Collectable;
import ch.hortis.sonar.model.FileMeasure;
import ch.hortis.sonar.model.Metrics;
import ch.hortis.sonar.model.ProjectMeasure;
import ch.hortis.sonar.mvn.mc.BaseMeasuresCollector;
import java.io.File;
import java.io.FilenameFilter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurefireCollector
extends BaseMeasuresCollector {
    private File[] reports;
    private List<UnitTestReport> unitTestReports;
    private List<FileMeasure> fileMeasures;

    @Override
    public boolean initialize(MavenProject project) {
        String baseDir = project.getBuild().getDirectory() + "/surefire-reports";
        this.reports = this.findSureFireReportFiles(baseDir);
        this.unitTestReports = new ArrayList<UnitTestReport>();
        return this.reports != null && this.reports.length > 0;
    }

    @Override
    public List<Collectable> collect() throws MojoExecutionException {
        ArrayList<Collectable> result = new ArrayList<Collectable>();
        result.addAll(this.collectProjectMeasures());
        result.addAll(this.fileMeasures);
        return result;
    }

    public List<ProjectMeasure> collectProjectMeasures() throws MojoExecutionException {
        this.fileMeasures = this.collectFileMeasures();
        ReportDataContainer dataContainer = new ReportDataContainer();
        for (UnitTestReport fileReport : this.unitTestReports) {
            dataContainer.cumulate(fileReport);
        }
        return dataContainer.asProjectMeasures();
    }

    public List<FileMeasure> collectFileMeasures() throws MojoExecutionException {
        ArrayList<FileMeasure> measures = new ArrayList<FileMeasure>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            for (File report : this.reports) {
                Document document = builder.parse(report);
                XPath xpath = XPathFactory.newInstance().newXPath();
                UnitTestReport fileReport = this.parseReport(xpath, document);
                this.unitTestReports.add(fileReport);
                measures.addAll(fileReport.asFileMeasures());
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error during surefire reports parsing", ex);
        }
        return measures;
    }

    private UnitTestReport parseReport(XPath xpath, Node root) throws XPathExpressionException, ParseException {
        Node testSuite = (Node)xpath.evaluate("//testsuite", root, XPathConstants.NODE);
        UnitTestReport test = new UnitTestReport();
        test.file = this.getFileFromClassName(xpath.evaluate("@name", testSuite));
        test.errors = this.parseNumber(xpath.evaluate("@errors", testSuite));
        test.skipped = this.parseNumber(xpath.evaluate("@skipped", testSuite));
        test.tests = this.parseNumber(xpath.evaluate("@tests", testSuite));
        test.time = this.parseNumber(xpath.evaluate("@time", testSuite));
        test.failures = this.parseNumber(xpath.evaluate("@failures", testSuite));
        return test;
    }

    private File[] findSureFireReportFiles(String sureFireOutputDirectory) {
        File reportsDir = new File(sureFireOutputDirectory);
        if (!reportsDir.exists()) {
            return null;
        }
        return reportsDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith("TEST-") && name.endsWith(".xml");
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UnitTestReport {
        private ch.hortis.sonar.model.File file;
        private double errors;
        private double skipped;
        private double tests;
        private double time;
        private double failures;

        private UnitTestReport() {
        }

        private List<FileMeasure> asFileMeasures() {
            ArrayList<FileMeasure> measures = new ArrayList<FileMeasure>();
            FileMeasure measure = new FileMeasure();
            measure.setFile(this.file);
            measure.setMetric(SurefireCollector.this.loadMetric(Metrics.SUREFIRE_ERRORS));
            measure.setValue(Double.valueOf(this.errors));
            measures.add(measure);
            measure = new FileMeasure();
            measure.setFile(this.file);
            measure.setMetric(SurefireCollector.this.loadMetric(Metrics.SUREFIRE_SKIPPED));
            measure.setValue(Double.valueOf(this.skipped));
            measures.add(measure);
            measure = new FileMeasure();
            measure.setFile(this.file);
            measure.setMetric(SurefireCollector.this.loadMetric(Metrics.SUREFIRE_FAILURES));
            measure.setValue(Double.valueOf(this.failures));
            measures.add(measure);
            measure = new FileMeasure();
            measure.setFile(this.file);
            measure.setMetric(SurefireCollector.this.loadMetric(Metrics.SUREFIRE_TESTS));
            measure.setValue(Double.valueOf(this.tests));
            measures.add(measure);
            measure = new FileMeasure();
            measure.setFile(this.file);
            measure.setMetric(SurefireCollector.this.loadMetric(Metrics.SUREFIRE_TIME));
            if (Double.valueOf(this.time).equals(Double.NaN)) {
                measure.setValue(Double.valueOf(Double.NaN));
            } else {
                measure.setValue(Double.valueOf(SurefireCollector.this.scaleValue(this.time * 1000.0, 3)));
            }
            measures.add(measure);
            return measures;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReportDataContainer {
        private UnitTestReport sum;

        private ReportDataContainer() {
            this.sum = new UnitTestReport();
        }

        private void cumulate(UnitTestReport toSum) {
            this.sum.errors += toSum.errors;
            this.sum.skipped += toSum.skipped;
            this.sum.failures += toSum.failures;
            this.sum.tests += toSum.tests;
            this.sum.time += toSum.time;
        }

        private List<ProjectMeasure> asProjectMeasures() {
            ArrayList<ProjectMeasure> measures = new ArrayList<ProjectMeasure>();
            List sumAsFileMeasures = this.sum.asFileMeasures();
            for (FileMeasure fileMeasure : sumAsFileMeasures) {
                ProjectMeasure measure = new ProjectMeasure();
                measure.setMetric(fileMeasure.getMetric());
                measure.setValue(fileMeasure.getValue());
                measures.add(measure);
            }
            return measures;
        }
    }
}

