/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.mc;

import ch.hortis.sonar.mvn.mc.XmlParserException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlReportParser {
    private Element root;
    private Document doc;
    private DocumentBuilder builder;

    public XmlReportParser() {
        DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
        try {
            bf.setFeature("http://apache.org/xml/features/validation/schema", false);
            bf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            bf.setFeature("http://xml.org/sax/features/validation", false);
            bf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            bf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            bf.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (ParserConfigurationException e) {
            Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
            log.error("Error occured during features set up.", (Throwable)e);
        }
        try {
            bf.setNamespaceAware(false);
            bf.setValidating(false);
            this.builder = bf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlParserException("can not instance a XML parser", e);
        }
    }

    public void parse(File file) {
        try {
            BufferedReader buffer = new BufferedReader(new FileReader(file));
            this.parse(buffer);
        }
        catch (IOException e) {
            throw new XmlParserException("can not parse the file " + file.getAbsolutePath(), e);
        }
    }

    public void parse(InputStream stream) {
        try {
            BufferedReader buffer = new BufferedReader(new InputStreamReader(stream));
            this.parse(buffer);
        }
        catch (IOException e) {
            throw new XmlParserException("can not parse the stream", e);
        }
    }

    private void parse(BufferedReader buffer) throws IOException {
        this.parse(IOUtils.toString((Reader)buffer));
    }

    public void parse(String xml) {
        try {
            xml = this.fixUnicodeChar(xml);
            this.doc = this.builder.parse(new ByteArrayInputStream(xml.getBytes()));
        }
        catch (SAXException e) {
            throw new XmlParserException("can not parse xml : " + xml, e);
        }
        catch (IOException e) {
            throw new XmlParserException("can not parse xml : " + xml, e);
        }
    }

    public Element getRoot() {
        if (this.root == null && this.doc != null) {
            this.root = this.doc.getDocumentElement();
        }
        return this.root;
    }

    public Element getChildElement(Element base, String elementName) {
        NodeList childrens = base.getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node nde = childrens.item(i);
            if (nde.getNodeType() != 1) continue;
            return (Element)nde;
        }
        return null;
    }

    public Element getChildElement(String elementName) {
        NodeList childrens = this.getRoot().getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node nde = childrens.item(i);
            if (nde.getNodeType() != 1) continue;
            return (Element)nde;
        }
        return null;
    }

    public List<Element> getChildElements(String elementName) {
        ArrayList<Element> rtrVal = new ArrayList<Element>();
        NodeList childrens = this.getRoot().getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node nde = childrens.item(i);
            if (nde.getNodeType() != 1) continue;
            rtrVal.add((Element)nde);
        }
        return rtrVal;
    }

    public List<Element> getChildElements(Element base, String elementName) {
        ArrayList<Element> rtrVal = new ArrayList<Element>();
        NodeList childrens = base.getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            Node nde = childrens.item(i);
            if (nde.getNodeType() != 1) continue;
            rtrVal.add((Element)nde);
        }
        return rtrVal;
    }

    public String getChildElementValue(Element base, String elementName) {
        NodeList childrens = base.getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            if (childrens.item(i).getNodeType() != 1) continue;
            return childrens.item(i).getFirstChild().getNodeValue();
        }
        return null;
    }

    public String getChildElementValue(String elementName) {
        NodeList childrens = this.getRoot().getElementsByTagName(elementName);
        for (int i = 0; i < childrens.getLength(); ++i) {
            if (childrens.item(i).getNodeType() != 1) continue;
            return childrens.item(i).getFirstChild().getNodeValue();
        }
        return null;
    }

    public Object executeXPath(Node node, QName qname, String xPathExpression) throws MojoExecutionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            XPathExpression expr = xpath.compile(xPathExpression);
            return expr.evaluate(node, qname);
        }
        catch (XPathExpressionException e) {
            throw new MojoExecutionException("Unable to evaluate xpath expression :" + xPathExpression, (Exception)e);
        }
    }

    public String executeXPath(String xPathExpression) throws MojoExecutionException {
        return (String)this.executeXPath(this.doc, XPathConstants.STRING, xPathExpression);
    }

    public String executeXPath(Node node, String xPathExpression) throws MojoExecutionException {
        return (String)this.executeXPath(node, XPathConstants.STRING, xPathExpression);
    }

    public NodeList executeXPathNodeList(String xPathExpression) throws MojoExecutionException {
        return (NodeList)this.executeXPath(this.doc, XPathConstants.NODESET, xPathExpression);
    }

    public NodeList executeXPathNodeList(Node node, String xPathExpression) throws MojoExecutionException {
        return (NodeList)this.executeXPath(node, XPathConstants.NODESET, xPathExpression);
    }

    protected String fixUnicodeChar(String text) {
        String unicode = "&u";
        StringBuilder replace = new StringBuilder(text);
        if (text.indexOf(unicode) >= 0) {
            Pattern p = Pattern.compile("&u([0-9a-fA-F]{1,4});");
            Matcher m = p.matcher(replace.toString());
            int nbFind = 0;
            while (m.find()) {
                replace.replace(m.start() + nbFind, m.end() + nbFind, "&#x" + m.group(1) + ";");
                ++nbFind;
            }
        }
        return replace.toString();
    }
}

