/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.reports;

import ch.hortis.sonar.mvn.MavenContext;
import ch.hortis.sonar.mvn.PomUtils;
import ch.hortis.sonar.mvn.reports.ReportHandler;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckstyleHandler
extends ReportHandler {
    @Override
    public void configurePlugin(MavenProject pom, Plugin plugin) throws MojoExecutionException {
        this.unsetConfigParameter(plugin, "outputDirectory");
        this.unsetConfigParameter(plugin, "outputFile");
        this.setConfigParameter(plugin, "outputFileFormat", "xml");
        this.setConfigParameter(plugin, "consoleOutput", "false");
        this.setConfigParameter(plugin, "enableRSS", "false");
        this.setConfigParameter(plugin, "failsOnError", "false");
        this.setConfigParameter(plugin, "linkXRef", "false");
        String ckeckStylePath = pom.getBuild().getDirectory() + "/sonar/checkstyle.xml";
        this.setConfigParameter(plugin, "configLocation", ckeckStylePath);
        PomUtils.copyPluginDependencies(pom, plugin);
    }

    @Override
    public boolean execute(MavenContext mavenContext, Log log) throws MojoExecutionException {
        String ckeckStylePath = mavenContext.getExecutedProject().getBuild().getDirectory() + "/sonar/checkstyle.xml";
        File checkstyle = new File(ckeckStylePath);
        try {
            mavenContext.getWebInterfaceService().getRemoteCheckstyleConfiguration(checkstyle);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error during sonar checkstyle config file download", (Exception)e);
        }
        return true;
    }

    @Override
    public List<String> getGoals() {
        return Arrays.asList("checkstyle");
    }

    @Override
    public boolean mustFailOnError() {
        return true;
    }
}

