/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.reports;

import ch.hortis.sonar.mvn.MavenContext;
import ch.hortis.sonar.mvn.PomUtils;
import ch.hortis.sonar.mvn.Report;
import ch.hortis.sonar.mvn.reports.ReportHandler;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverHandler
extends ReportHandler {
    @Override
    public void configurePlugin(MavenProject pom, Plugin plugin) {
        File cloverLicense;
        this.unsetConfigParameter(plugin, "outputDirectory");
        this.setConfigParameter(plugin, "generateHistorical", "false");
        this.setConfigParameter(plugin, "generateXml", "true");
        this.setConfigParameter(plugin, "generatePdf", "false");
        this.setConfigParameter(plugin, "generateHtml", "false");
        String javaVersion = PomUtils.getJavaVersion(pom);
        if (PomUtils.getConfigurationValue(plugin, "licenseLocation") == null && (cloverLicense = CloverHandler.getCloverLicense(pom)).exists()) {
            this.setConfigParameter(plugin, "licenseLocation", cloverLicense.getPath());
        }
        if (javaVersion != null) {
            this.setConfigParameter(plugin, "jdk", javaVersion);
        }
    }

    @Override
    public boolean execute(MavenContext mavenContext, Log log) {
        return CloverHandler.isLicenceProvided(mavenContext);
    }

    public static final boolean isLicenceProvided(MavenContext mavenContext) {
        MavenProject pom = mavenContext.getExecutedProject();
        Plugin plugin = Report.Clover.getReportHandler().createPluginWithConfiguration(pom);
        String licenseLocation = PomUtils.getConfigurationValue(plugin, "licenseLocation");
        File license = null;
        license = licenseLocation != null ? new File(licenseLocation) : CloverHandler.getCloverLicense(pom);
        return license != null && license.exists();
    }

    public static final File getCloverLicense(MavenProject pom) {
        return new File(pom.getBasedir(), "clover.license");
    }

    @Override
    public List<String> getGoals() {
        return Arrays.asList("instrument", "clover");
    }

    @Override
    public boolean mustFailOnError() {
        return false;
    }

    @Override
    public boolean executeEvenIfNoJavaSources() {
        return false;
    }

    @Override
    public boolean executeEvenIfNoJavaTests() {
        return false;
    }
}

