/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.reports;

import ch.hortis.sonar.mvn.MavenContext;
import ch.hortis.sonar.mvn.PomUtils;
import ch.hortis.sonar.mvn.reports.ReportHandler;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMDHandler
extends ReportHandler {
    @Override
    public boolean executeEvenIfNoJavaSources() {
        return false;
    }

    @Override
    public void configurePlugin(MavenProject pom, Plugin plugin) {
        this.unsetConfigParameter(plugin, "outputDirectory");
        this.unsetConfigParameter(plugin, "targetDirectory");
        this.setConfigParameter(plugin, "format", "xml");
        this.setConfigParameter(plugin, "linkXRef", "false");
        String javaVersion = PomUtils.getJavaVersion(pom);
        if (javaVersion != null) {
            if (javaVersion.equals("1.1") || javaVersion.equals("1.2")) {
                this.setConfigParameter(plugin, "targetJdk", "1.3");
            } else {
                this.setConfigParameter(plugin, "targetJdk", javaVersion);
            }
        }
        this.unsetConfigParameter(plugin, "rulesets");
        Xpp3Dom conf = (Xpp3Dom)plugin.getConfiguration();
        Xpp3Dom rulesets = new Xpp3Dom("rulesets");
        Xpp3Dom ruleset = new Xpp3Dom("ruleset");
        ruleset.setValue(pom.getBuild().getDirectory() + "/sonar/pmd.xml");
        rulesets.addChild(ruleset);
        conf.addChild(rulesets);
        PomUtils.copyPluginDependencies(pom, plugin);
    }

    @Override
    public boolean execute(MavenContext mavenContext, Log log) throws MojoExecutionException {
        File pmd = new File(mavenContext.getExecutedProject().getBuild().getDirectory() + "/sonar/pmd.xml");
        try {
            mavenContext.getWebInterfaceService().getRemotePMDConfiguration(pmd);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during sonar PMD config file download", e);
        }
        return true;
    }

    @Override
    public List<String> getGoals() {
        return Arrays.asList("pmd");
    }

    @Override
    public boolean mustFailOnError() {
        return true;
    }
}

