/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn.reports;

import ch.hortis.sonar.mvn.MavenContext;
import ch.hortis.sonar.mvn.PomUtils;
import ch.hortis.sonar.mvn.Report;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReportHandler {
    private Report report;

    public final void preparePom(MavenProject pom) throws MojoExecutionException {
        Plugin plugin = this.createPluginWithConfiguration(pom);
        this.configurePlugin(pom, plugin);
        this.definePlugin(pom, plugin);
    }

    public abstract void configurePlugin(MavenProject var1, Plugin var2) throws MojoExecutionException;

    public abstract boolean mustFailOnError();

    public abstract List<String> getGoals();

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public boolean execute(MavenContext mavenContext, Log log) throws MojoExecutionException {
        return true;
    }

    public boolean executeEvenIfNoJavaSources() {
        return true;
    }

    public boolean executeEvenIfNoJavaTests() {
        return true;
    }

    public final List<String> getCommands() {
        ArrayList<String> goals = new ArrayList<String>();
        String prefix = this.report.getGroupId() + ":" + this.report.getArtifactId() + ":" + this.report.getVersion() + ":";
        for (String goal : this.getGoals()) {
            goals.add(prefix + goal);
        }
        return goals;
    }

    protected final Plugin createPluginWithConfiguration(MavenProject pom) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(this.report.getGroupId());
        plugin.setArtifactId(this.report.getArtifactId());
        plugin.setVersion(this.getPluginVersion(pom));
        Xpp3Dom configuration = PomUtils.findPluginConfiguration(pom, this.report.getGroupId(), this.report.getArtifactId());
        plugin.setConfiguration((Object)configuration);
        return plugin;
    }

    private String getPluginVersion(MavenProject pom) {
        Plugin pomPlugin;
        if (!this.report.isVersionFixed() && (pomPlugin = PomUtils.findPlugin(pom, this.report.getGroupId(), this.report.getArtifactId())) != null && pomPlugin.getVersion() != null) {
            return pomPlugin.getVersion();
        }
        return this.report.getVersion();
    }

    protected final void setConfigParameterIfNotAlreadySet(Plugin plugin, String key, String value) {
        String previousValue = PomUtils.getConfigurationValue(plugin, key);
        if (previousValue == null) {
            this.setConfigParameter(plugin, key, value);
        }
    }

    protected final void setConfigParameter(Plugin plugin, String key, String value) {
        Xpp3Dom node;
        Xpp3Dom conf = (Xpp3Dom)plugin.getConfiguration();
        if (conf == null) {
            conf = new Xpp3Dom("configuration");
            plugin.setConfiguration((Object)conf);
        }
        if ((node = conf.getChild(key)) == null) {
            node = new Xpp3Dom(key);
            conf.addChild(node);
        }
        node.setValue(value);
    }

    protected final void unsetConfigParameter(Plugin plugin, String key) {
        Xpp3Dom conf = (Xpp3Dom)plugin.getConfiguration();
        if (conf != null) {
            for (int i = 0; i < conf.getChildCount(); ++i) {
                Xpp3Dom node = conf.getChild(i);
                if (!node.getName().equals(key)) continue;
                conf.removeChild(i);
                break;
            }
        }
    }

    protected void definePlugin(MavenProject pom, Plugin plugin) {
        Plugin p;
        Iterator i;
        if (pom.getBuild().getPlugins() == null) {
            pom.getBuild().setPlugins(new ArrayList());
        } else {
            i = pom.getBuild().getPlugins().iterator();
            while (i.hasNext()) {
                p = (Plugin)i.next();
                if (!p.getArtifactId().equals(plugin.getArtifactId()) || !p.getGroupId().equals(p.getGroupId())) continue;
                i.remove();
            }
        }
        if (pom.getBuild() != null && pom.getBuild().getPluginManagement() != null) {
            i = pom.getBuild().getPluginManagement().getPlugins().iterator();
            while (i.hasNext()) {
                p = (Plugin)i.next();
                if (!p.getArtifactId().equals(plugin.getArtifactId()) || !p.getGroupId().equals(p.getGroupId())) continue;
                i.remove();
            }
        }
        if (pom.getReporting() != null && pom.getReporting().getPlugins() != null) {
            i = pom.getReporting().getPlugins().iterator();
            while (i.hasNext()) {
                p = (ReportPlugin)i.next();
                if (!p.getArtifactId().equals(plugin.getArtifactId()) || !p.getGroupId().equals(p.getGroupId())) continue;
                i.remove();
            }
        }
        pom.getBuild().getPlugins().add(plugin);
    }
}

