/*
 * Sonar, entreprise quality control tool.
 * Copyright (C) 2007-2008 Hortis-GRC SA
 * mailto:be_agile HAT hortis DOT ch
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with {library}; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package ch.hortis.sonar.mvn;

import org.apache.maven.plugin.MojoExecutionException;
import org.sonar.plugins.api.maven.MavenPluginHandler;
import org.sonar.plugins.api.maven.model.MavenPom;

import java.util.*;

/**
 * @goal prepare
 */
public class PrepareMojo extends CoreMojo {

  @Override
  public void doExecute() throws MojoExecutionException {
    for (MavenPluginHandler mavenPluginHandler : getContainer().getMavenPluginHandlers()) {
      prepareMavenPlugin(mavenPluginHandler);
    }
  }

  private void prepareMavenPlugin(MavenPluginHandler handler) {
    handler.configure(new MavenPom(mavenProject));
    for (String command : getCommands(handler)) {
      String goals = mavenProject.getProperties().getProperty("sonar.bootstrap.additional.goals");
      if (goals == null) {
        goals = "";
      }
      goals += command + ',' + handler.shouldStopOnFailure() + ';';
      mavenProject.getProperties().setProperty("sonar.bootstrap.additional.goals", goals);
    }
  }


  private List<String> getCommands(MavenPluginHandler handler) {
    List<String> goals = new ArrayList<String>();
    String prefix = handler.getGroupId() + ':' + handler.getArtifactId() + "::";
    for (String goal : handler.getGoals()) {
      goals.add(prefix + goal);
    }
    return goals;
  }
}