/*
 * Sonar, entreprise quality control tool.
 * Copyright (C) 2007-2008 Hortis-GRC SA
 * mailto:be_agile HAT hortis DOT ch
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with {library}; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.maven;

import ch.hortis.sonar.service.*;
import org.apache.maven.model.*;
import org.apache.maven.plugin.*;
import org.apache.maven.project.MavenProject;
import org.sonar.plugins.api.maven.model.*;

import java.util.List;

/**
 * @goal dependencies
 */
public class DependenciesInjectionMojo extends AbstractMojo {

  /**
   * The maven project running this plugin
   * @parameter expression="${project}"
   * @required
   * @readonly
   */
  private MavenProject mavenProject;
  
  /**
   * Sonar host URL
   * @parameter expression="${sonar.host.url}" default-value="http://localhost:9000" alias="sonar.host.url"
   */
  private String sonarHostURL;
  
  /**
   * Sonar server version
   * @parameter expression="${sonar.server.version}" alias="sonar.server.version"
   */
  private String sonarServerVersion;

  private WebInterfaceService webInterfaceService;

  public DependenciesInjectionMojo() {	 
  }
  
  public void setWebInterfaceService( WebInterfaceService webInterfaceService ) {
    this.webInterfaceService = webInterfaceService;
  }
  
  public void setMavenProject(MavenProject mavenProject) {
    this.mavenProject = mavenProject;
  }

  public void execute() throws MojoExecutionException {
    
    if ( webInterfaceService == null ) {
      webInterfaceService = new WebInterfaceServiceImpl( sonarHostURL );
    }         
    preparePomForSonar();
  }
  
  private void preparePomForSonar() throws MojoExecutionException {
    // adding the repository
    List<Repository> repositories = mavenProject.getRepositories();
    for (Repository repository : repositories) {
      if ("sonar".equals(repository.getId())) {
        throw new MojoExecutionException("Pom already contains a repository with id 'sonar', please remove it");
      }
    }

    Repository sonarRepository = new Repository();
    sonarRepository.setId("sonar");
    sonarRepository.setName("Sonar server maven repository");
    RepositoryPolicy snapshotPolicy = new RepositoryPolicy();
    snapshotPolicy.setChecksumPolicy("ignore");
    snapshotPolicy.setEnabled(true);
    snapshotPolicy.setUpdatePolicy("always");
    sonarRepository.setSnapshots(snapshotPolicy);
    sonarRepository.setUrl(webInterfaceService.getSonarMavenRepository());
    repositories.add(sonarRepository);

    MavenPom pom = new MavenPom(mavenProject);
    MavenPlugin plugin = pom.findOrCreateBuildPlugin("org.codehaus.sonar", "sonar-core-maven-plugin", sonarServerVersion);
    plugin.addDependency("org.codehaus.sonar.runtime", "jdbc-driver", "1.0-SNAPSHOT", "pom");
    plugin.addDependency("org.codehaus.sonar.runtime", "plugins", "1.0-SNAPSHOT", "pom");
//    MavenUtils.addDependencyToPlugin(pom, "org.codehaus.sonar", "sonar-core-maven-plugin", sonarServerVersion,
//                          "org.codehaus.sonar.runtime", "jdbc-driver", "1.0-SNAPSHOT", "pom");
    
//    MavenUtils.addDependencyToPlugin(pom, "org.codehaus.sonar", "sonar-core-maven-plugin", sonarServerVersion,
//        "org.codehaus.sonar.runtime", "plugins", "1.0-SNAPSHOT", "pom");
  }
  
}