/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn;

import ch.hortis.sonar.model.Snapshot;
import ch.hortis.sonar.mvn.CoreMojo;
import ch.hortis.sonar.service.WebInterfaceService;
import ch.hortis.sonar.service.WebInterfaceServiceImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Query;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.sonar.commons.DaoFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchLaunchMojo
extends CoreMojo {
    private String sonarHostURL;
    private WebInterfaceService webInterfaceService;
    private DaoFacade daoFacade;

    public void setWebInterfaceService(WebInterfaceService webInterfaceService) {
        this.webInterfaceService = webInterfaceService;
    }

    @Override
    public void doExecute() throws MojoExecutionException {
        try {
            this.daoFacade = (DaoFacade)this.getContainer().getComponent(DaoFacade.class);
            Set<Integer> snapshotIds = this.processSnapshots();
            Snapshot topLevel = this.getTopLevelSnapshot();
            if (topLevel == null) {
                throw new MojoExecutionException("Unable to find top level snapshot");
            }
            this.updateRootColumn(snapshotIds, topLevel);
            this.notifyServer(topLevel);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error occured when triggering measures calculation job on remote server", e);
        }
    }

    private void notifyServer(Snapshot topLevel) throws IOException {
        if (this.webInterfaceService == null) {
            this.webInterfaceService = new WebInterfaceServiceImpl(this.sonarHostURL);
        }
        this.webInterfaceService.triggerMeasuresCalculations(topLevel.getId());
    }

    private void updateRootColumn(Set<Integer> snapshotIds, Snapshot rootSnapshot) {
        snapshotIds.remove(rootSnapshot.getId());
        if (!snapshotIds.isEmpty()) {
            Query query = this.daoFacade.getDatabaseManager().createQuery("update Snapshot s set s.root=:root where s.id in (:snapshotIds) or s.root in (:snapshotIds)");
            query.setParameter("root", (Object)rootSnapshot);
            query.setParameter("snapshotIds", snapshotIds);
            query.executeUpdate();
            this.daoFacade.getDatabaseManager().commit();
        }
    }

    private Set<Integer> processSnapshots() throws MojoExecutionException {
        HashSet<Integer> snapshotIds = new HashSet<Integer>();
        for (MavenProject reactorProject : this.getReactorProjects()) {
            this.processSnapshot(reactorProject, null, snapshotIds);
        }
        this.daoFacade.getDatabaseManager().commit();
        return snapshotIds;
    }

    private void processSnapshot(MavenProject reactorProject, Snapshot parent, Set<Integer> snapshotIds) throws MojoExecutionException {
        Integer projectBoundSnapshotId = this.getSnapshotId(reactorProject);
        Snapshot projectBoundSnapshot = (Snapshot)this.daoFacade.getDatabaseManager().getEntityManager().find(Snapshot.class, (Object)projectBoundSnapshotId);
        if (projectBoundSnapshot == null) {
            throw new MojoExecutionException("Unable to find Snapshot " + projectBoundSnapshotId + " bound to the pom");
        }
        snapshotIds.add(projectBoundSnapshotId);
        if (parent != null) {
            projectBoundSnapshot.setParent(parent);
        }
        this.daoFacade.getDatabaseManager().merge((Object)projectBoundSnapshot);
        this.saveSnapshotHierarchyModules(projectBoundSnapshot, reactorProject, snapshotIds);
    }

    private void saveSnapshotHierarchyModules(Snapshot snapshot, MavenProject reactorProject, Set<Integer> snapshotIds) throws MojoExecutionException {
        for (Object moduleNames : reactorProject.getModules()) {
            String moduleName = (String)moduleNames;
            File moduleFile = new File(reactorProject.getBasedir() + "/" + moduleName + "/pom.xml");
            MavenProject targetReactorProject = null;
            for (MavenProject project : this.getReactorProjects()) {
                try {
                    if (!project.getFile().getCanonicalFile().equals(moduleFile.getCanonicalFile())) continue;
                    targetReactorProject = project;
                    break;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to resolve canonical path of pom.xml", (Exception)e);
                }
            }
            if (targetReactorProject == null) continue;
            this.processSnapshot(targetReactorProject, snapshot, snapshotIds);
        }
    }

    private Snapshot getTopLevelSnapshot() throws MojoExecutionException {
        for (MavenProject reactorProject : this.getReactorProjects()) {
            Integer projectBoundSnapshotId = super.getSnapshotId(reactorProject);
            Snapshot projectBoundSnapshot = (Snapshot)this.daoFacade.getDatabaseManager().getEntityManager().find(Snapshot.class, (Object)projectBoundSnapshotId);
            if (projectBoundSnapshot.getParent() != null || this.getReactorProjects().size() != 1 && this.daoFacade.getMeasuresDao().getChildSnapshots(projectBoundSnapshot, false).size() <= 0) continue;
            return projectBoundSnapshot;
        }
        return null;
    }
}

