/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.mvn;

import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.sonar.commons.database.DatabaseConnector;
import org.sonar.commons.database.DriverDatabaseConnector;
import org.sonar.maven.MavenContainer;
import org.sonar.plugins.api.maven.model.MavenPom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CoreMojo
extends AbstractMojo {
    private static final String SNAPSHOT_ID_PROP = "sonar.snaphsotId";
    private List<MavenProject> reactorProjects;
    protected MavenProject mavenProject;
    private String jdbcURL;
    private String jdbcDriverClassName;
    private String jdbcUserName;
    private String jdbcPassword;
    private String jdbcDialect;
    private String jdbcDialectClass;
    private String branch;
    private MavenContainer container;
    private DatabaseConnector databaseConnector = null;
    private MavenPom mavenPom = null;

    public void setDatabaseConnector(DatabaseConnector databaseConnector) {
        this.databaseConnector = databaseConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doExecute();
        }
        finally {
            if (this.container != null) {
                try {
                    this.container.stop();
                }
                catch (Throwable throwable) {}
                this.container = null;
            }
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    protected void setReactorProjects(List<MavenProject> reactorProjects) {
        this.reactorProjects = reactorProjects;
    }

    protected List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected String getBranch() {
        return this.branch;
    }

    protected void setBranch(String branch) {
        this.branch = branch;
    }

    protected void setProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    protected void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    protected void setJdbcDriverClassName(String jdbcDriverClassName) {
        this.jdbcDriverClassName = jdbcDriverClassName;
    }

    protected void setJdbcUserName(String jdbcUserName) {
        this.jdbcUserName = jdbcUserName;
    }

    protected void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    protected Integer getSnapshotId(MavenProject pom) {
        String propValue = pom.getProperties().getProperty(SNAPSHOT_ID_PROP);
        if (propValue == null) {
            throw new IllegalStateException("Unable to retrieve property 'sonar.snaphsotId' from pom");
        }
        return Integer.valueOf(propValue);
    }

    protected void setSnapshotId(Integer id, MavenProject pom) {
        pom.getProperties().setProperty(SNAPSHOT_ID_PROP, id.toString());
    }

    protected DatabaseConnector getDatabaseConnector() {
        if (this.databaseConnector == null) {
            PropertiesConfiguration config = new PropertiesConfiguration();
            config.setProperty("sonar.jdbc.url", (Object)this.jdbcURL);
            config.setProperty("sonar.jdbc.driver", (Object)this.jdbcDriverClassName);
            config.setProperty("sonar.jdbc.user", (Object)this.jdbcUserName);
            config.setProperty("sonar.jdbc.password", (Object)this.jdbcPassword);
            config.setProperty("sonar.jdbc.dialect", (Object)this.jdbcDialect);
            config.setProperty("sonar.jdbc.dialectClass", (Object)this.jdbcDialectClass);
            config.setProperty("sonar.jdbc.hibernateSecondLevelCache", (Object)Boolean.FALSE);
            this.databaseConnector = new DriverDatabaseConnector((Configuration)config);
        }
        return this.databaseConnector;
    }

    protected MavenContainer getContainer() {
        if (this.container == null) {
            this.container = new MavenContainer(this.getLog(), this.getDatabaseConnector(), this.mavenProject);
            this.container.start();
        }
        return this.container;
    }

    protected MavenPom getMavenPom() {
        if (this.mavenPom == null) {
            this.mavenPom = new MavenPom(this.mavenProject);
        }
        return this.mavenPom;
    }
}

