/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven;

import ch.hortis.sonar.model.MavenProject;
import ch.hortis.sonar.model.ProjectLink;
import ch.hortis.sonar.model.Snapshot;
import ch.hortis.sonar.mvn.CoreMojo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.apache.commons.configuration.Configuration;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.sonar.commons.DaoFacade;
import org.sonar.commons.database.DatabaseManager;
import org.sonar.plugins.api.maven.AbstractMeasuresRecorder;
import org.sonar.plugins.api.maven.MavenCollector;
import org.sonar.plugins.api.maven.MavenUtils;

public class CollectMojo
extends CoreMojo {
    public static final String PARAM_DATE = "sonar.projectDate";
    public static final String PARAM_VERSION = "sonar.projectVersion";

    public void doExecute() throws MojoExecutionException {
        Snapshot snapshot = this.createSnapshot();
        for (AbstractMeasuresRecorder recorder : this.getContainer().getComponents(AbstractMeasuresRecorder.class)) {
            recorder.setRootSnapshot(snapshot);
        }
        List<MavenCollector> collectors = this.getContainer().getMavenCollectors();
        for (MavenCollector collector : collectors) {
            try {
                this.getLog().info((CharSequence)("Starting " + collector.getClass()));
                collector.collect(this.getMavenPom());
            }
            catch (RuntimeException e) {
                if (collector.shouldStopOnFailure()) {
                    throw e;
                }
                this.getLog().error((CharSequence)("error while collecting " + collector.getClass().getSimpleName()));
            }
        }
        this.setSnapshotId(snapshot.getId(), this.mavenProject);
    }

    private Snapshot createSnapshot() {
        DaoFacade daoFacade = (DaoFacade)this.getContainer().getComponent(DaoFacade.class);
        DatabaseManager dbManager = daoFacade.getDatabaseManager();
        MavenProject dbProject = this.loadProjectFromDatabase(this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), MavenUtils.getBranch((org.apache.maven.project.MavenProject)this.mavenProject), dbManager);
        if (dbProject == null) {
            dbProject = MavenProject.newMavenProject((String)this.mavenProject.getGroupId(), (String)this.mavenProject.getArtifactId(), (String)MavenUtils.getBranch((org.apache.maven.project.MavenProject)this.mavenProject), (String)this.mavenProject.getName());
            dbProject.setQualifier(this.getMavenPom().getLanguage().getProjectQualifier());
        }
        dbProject.setName(this.mavenProject.getName());
        dbProject.setDescription(this.mavenProject.getDescription());
        dbProject = (MavenProject)dbManager.save((Object)dbProject);
        this.updateProject(dbProject, this.mavenProject);
        Snapshot snapshot = new Snapshot();
        snapshot.setMavenProject(dbProject);
        snapshot.setVersion(this.getProjectVersion(this.getContainer().getConfiguration(), this.mavenProject));
        snapshot.setCreatedAt(this.getProjectDate(this.getContainer().getConfiguration()));
        dbManager.save((Object)snapshot);
        return snapshot;
    }

    protected String getProjectVersion(Configuration configuration, org.apache.maven.project.MavenProject pom) {
        String version = configuration.getString(PARAM_VERSION);
        if (version == null) {
            version = pom.getVersion();
        }
        return version;
    }

    protected Date getProjectDate(Configuration configuration) {
        String formattedDate = configuration.getString(PARAM_DATE);
        if (formattedDate == null) {
            return new Date();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return format.parse(formattedDate);
        }
        catch (ParseException e) {
            throw new RuntimeException("The property sonar.projectDate does not respect the format yyyy-MM-dd (for example 2008-05-23) : " + formattedDate, e);
        }
    }

    private MavenProject loadProjectFromDatabase(String groupId, String artifactId, String branch, DatabaseManager dbManager) {
        try {
            Query query = dbManager.getEntityManager().createQuery("SELECT p FROM MavenProject p WHERE p.scope=:scope AND p.key=:key AND p.enabled=true");
            query.setParameter("scope", (Object)"PRJ");
            query.setParameter("key", (Object)MavenProject.toMavenKey((String)groupId, (String)artifactId, (String)branch));
            return (MavenProject)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private void updateProject(MavenProject sonarProject, org.apache.maven.project.MavenProject pom) {
        this.updateProjectLink("homepage", pom.getUrl(), sonarProject);
        Scm scmConfig = pom.getScm();
        if (scmConfig == null) {
            scmConfig = new Scm();
        }
        this.updateProjectLink("scm", scmConfig.getUrl(), sonarProject);
        this.updateProjectLink("scm_dev", scmConfig.getDeveloperConnection(), sonarProject);
        this.updateProjectLink("scm_ro", scmConfig.getConnection(), sonarProject);
        CiManagement cimConfig = pom.getCiManagement();
        if (cimConfig == null) {
            cimConfig = new CiManagement();
        }
        this.updateProjectLink("ci", cimConfig.getUrl(), sonarProject);
        IssueManagement imConfig = pom.getIssueManagement();
        if (imConfig == null) {
            imConfig = new IssueManagement();
        }
        this.updateProjectLink("issue", imConfig.getUrl(), sonarProject);
    }

    private void updateProjectLink(String linkType, String href, MavenProject sonarProject) {
        if (href != null && !"".equals(href)) {
            ProjectLink link = sonarProject.getProjectLinkByType(linkType);
            if (link == null) {
                link = new ProjectLink();
                link.setMavenProject(sonarProject);
                link.setType(linkType);
                sonarProject.getProjectLinks().add(link);
            }
            link.setHref(href);
        }
    }
}

