/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven;

import ch.hortis.sonar.service.WebInterfaceService;
import ch.hortis.sonar.service.WebInterfaceServiceImpl;
import java.util.List;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.sonar.plugins.api.maven.model.MavenPlugin;
import org.sonar.plugins.api.maven.model.MavenPom;

public class DependenciesInjectionMojo
extends AbstractMojo {
    private MavenProject mavenProject;
    private String sonarHostURL;
    private String sonarServerVersion;
    private WebInterfaceService webInterfaceService;

    public void setWebInterfaceService(WebInterfaceService webInterfaceService) {
        this.webInterfaceService = webInterfaceService;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public void execute() throws MojoExecutionException {
        if (this.webInterfaceService == null) {
            this.webInterfaceService = new WebInterfaceServiceImpl(this.sonarHostURL);
        }
        this.preparePomForSonar();
    }

    private void preparePomForSonar() throws MojoExecutionException {
        List repositories = this.mavenProject.getRepositories();
        for (Repository repository : repositories) {
            if (!"sonar".equals(repository.getId())) continue;
            throw new MojoExecutionException("Pom already contains a repository with id 'sonar', please remove it");
        }
        Repository sonarRepository = new Repository();
        sonarRepository.setId("sonar");
        sonarRepository.setName("Sonar server maven repository");
        RepositoryPolicy snapshotPolicy = new RepositoryPolicy();
        snapshotPolicy.setChecksumPolicy("ignore");
        snapshotPolicy.setEnabled(true);
        snapshotPolicy.setUpdatePolicy("always");
        sonarRepository.setSnapshots(snapshotPolicy);
        sonarRepository.setUrl(this.webInterfaceService.getSonarMavenRepository());
        repositories.add(sonarRepository);
        MavenPom pom = new MavenPom(this.mavenProject);
        MavenPlugin plugin = pom.findOrCreateBuildPlugin("org.codehaus.sonar", "sonar-core-maven-plugin", this.sonarServerVersion);
        plugin.addDependency("org.codehaus.sonar.runtime", "jdbc-driver", "1.0-SNAPSHOT", "pom");
        plugin.addDependency("org.codehaus.sonar.runtime", "plugins", "1.0-SNAPSHOT", "pom");
    }
}

