/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.picocontainer.Characteristics;
import org.picocontainer.MutablePicoContainer;
import org.sonar.commons.Context;
import org.sonar.commons.DaoFacade;
import org.sonar.commons.IocContainer;
import org.sonar.commons.database.DatabaseConnector;
import org.sonar.commons.database.DatabaseManagerFactory;
import org.sonar.maven.MavenConfiguration;
import org.sonar.plugins.api.Extension;
import org.sonar.plugins.api.Plugins;
import org.sonar.plugins.api.maven.JavaMeasuresRecorder;
import org.sonar.plugins.api.maven.MavenCollector;
import org.sonar.plugins.api.maven.MavenCollectorFilter;
import org.sonar.plugins.api.maven.MavenExtension;
import org.sonar.plugins.api.maven.MavenPluginHandler;
import org.sonar.plugins.api.maven.PlsqlMeasuresRecorder;
import org.sonar.plugins.api.maven.model.MavenPom;
import org.sonar.plugins.api.rules.RulesManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenContainer {
    private MutablePicoContainer pico = IocContainer.buildPicoContainer();

    public MavenContainer(Log mavenLog, DatabaseConnector databaseConnector, MavenProject pom) {
        Plugins plugins = new Plugins();
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)Context.MAVEN);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)pom);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)mavenLog);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)databaseConnector);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(DaoFacade.class);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent((Object)plugins);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(RulesManagerImpl.class);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(DatabaseManagerFactory.class);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(MavenConfiguration.class);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(MavenPom.class);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(JavaMeasuresRecorder.class);
        this.pico.as(new Properties[]{Characteristics.CACHE}).addComponent(PlsqlMeasuresRecorder.class);
        this.loadExtensions(this.pico, plugins.getExtensions(MavenExtension.class));
    }

    public void start() {
        this.pico.start();
    }

    public void stop() {
        this.pico.stop();
        this.pico = null;
    }

    private MavenPom getMavenPom() {
        return (MavenPom)this.pico.getComponent(MavenPom.class);
    }

    public List<MavenCollector> getMavenCollectors() {
        ArrayList<MavenCollector> result = new ArrayList<MavenCollector>();
        MavenPom pom = this.getMavenPom();
        for (MavenCollector mavenCollector : this.pico.getComponents(MavenCollector.class)) {
            if (!mavenCollector.shouldCollectOn(pom)) continue;
            result.add(mavenCollector);
        }
        for (MavenCollectorFilter filter : this.pico.getComponents(MavenCollectorFilter.class)) {
            filter.filter(result, pom);
        }
        return result;
    }

    public List<MavenPluginHandler> getMavenPluginHandlers() {
        MutablePicoContainer childPico = this.pico.makeChildContainer();
        for (MavenCollector mavenCollector : this.getMavenCollectors()) {
            Class mavenPluginHandlerClass = mavenCollector.dependsOnMavenPlugin(this.getMavenPom());
            if (mavenPluginHandlerClass == null) continue;
            childPico.addComponent((Object)mavenPluginHandlerClass);
        }
        childPico.start();
        return childPico.getComponents(MavenPluginHandler.class);
    }

    public Configuration getConfiguration() {
        return (Configuration)this.pico.getComponent(Configuration.class);
    }

    public Object getComponent(Object key) {
        return this.pico.getComponent(key);
    }

    public <T> List<T> getComponents(Class<T> key) {
        return this.pico.getComponents(key);
    }

    public void loadExtensions(MutablePicoContainer container, List<Class<? extends Extension>> extensionClasses) {
        for (Class<? extends Extension> extensionClass : extensionClasses) {
            container.as(new Properties[]{Characteristics.CACHE}).addComponent(extensionClass);
        }
    }
}

