/*
 * Decompiled with CFR 0.152.
 */
package ch.hortis.sonar.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.derby.drda.NetworkServerControl;

public class DatabaseEmbedder {
    private static final Properties DEFAULT_PROPS = DatabaseEmbedder.getDefaultProperties();
    private NetworkServerControl serverControl = null;
    private File dbHome;
    private Properties dbProps;
    private PrintWriter dbLog;

    public DatabaseEmbedder(File dbHome) {
        this.dbHome = dbHome;
        this.dbProps = DEFAULT_PROPS;
    }

    public DatabaseEmbedder(File dbHome, Properties dbProps) {
        this(dbHome);
        this.dbProps = dbProps;
    }

    public void setDbLog(PrintWriter dbLog) {
        this.dbLog = dbLog;
    }

    public void start() throws Exception {
        String providedPort;
        if (this.dbHome.exists() && !this.dbHome.isDirectory()) {
            throw new Exception("Database home " + this.dbHome.getPath() + " is not a directory");
        }
        if (!this.dbHome.exists()) {
            this.dbHome.mkdirs();
        }
        System.setProperty("derby.system.home", this.dbHome.getPath());
        if (this.dbProps != null) {
            File derbyProps = new File(this.dbHome.getPath() + "/derby.properties");
            this.dbProps.store(new FileOutputStream(derbyProps), "GENERATED FILE, DO NOT EDIT ME UNLESS YOU WANT TO LOOSE YOUR TIME ;O)");
        }
        if ((providedPort = this.dbProps.getProperty("derby.drda.portNumber")) == null || providedPort.equals("")) {
            throw new Exception("Missing derby.drda.portNumber property");
        }
        int port = Integer.parseInt(providedPort);
        this.serverControl = new NetworkServerControl(InetAddress.getByName("localhost"), port);
        this.serverControl.start(this.dbLog);
        this.ensureServerIsUp();
    }

    public File getDbHome() {
        return this.dbHome;
    }

    public void stop() throws Exception {
        if (this.serverControl != null) {
            this.serverControl.shutdown();
            this.ensureServerIsDown();
            this.serverControl = null;
        }
    }

    private void ensureServerIsUp() throws Exception {
        for (int retry = 0; retry < 16; ++retry) {
            try {
                this.serverControl.ping();
                return;
            }
            catch (Exception ex) {
                this.sleep(250L);
                continue;
            }
        }
        throw new Exception("Embedded server does not respond to ping requests");
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void ensureServerIsDown() throws Exception {
        for (int retry = 0; retry < 16; ++retry) {
            try {
                this.serverControl.ping();
                this.sleep(250L);
                continue;
            }
            catch (Exception ex) {
                return;
            }
        }
        throw new Exception("Embedded server did not stop");
    }

    public static Properties getDefaultProperties() {
        Properties props = new Properties();
        props.setProperty("derby.drda.startNetworkServer", "true");
        props.setProperty("derby.drda.portNumber", "1527");
        props.setProperty("derby.drda.maxThreads", "20");
        props.setProperty("derby.drda.minThreads", "2");
        props.setProperty("derby.drda.logConnections", "false");
        props.setProperty("derby.stream.error.logSeverityLevel", "20000");
        props.setProperty("derby.connection.requireAuthentication", "true");
        props.setProperty("derby.user.sonar", "sonar");
        return props;
    }
}

