package dev.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on sonar-dev-maven-plugin.<br/> Call <pre>  mvn sonar-dev:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Nov 19 14:21:35 CET 2010
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.6)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.codehaus.sonar:sonar-dev-maven-plugin:1.0.1", 0 );
        append( sb, "", 0 );

        append( sb, "Sonar :: Development Maven Plugin", 0 );
        append( sb, "Maven plugin for Sonar development environment", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 7 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "analyze".equals( goal ) )
        {
            append( sb, "sonar-dev:analyze", 0 );
            append( sb, "Analyzes projects using Sonar.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir (Default: ${basedir})", 2 );
                append( sb, "The base directory from which to execute the Ant script.", 3 );
                append( sb, "", 0 );

                append( sb, "database (Default: derby)", 2 );
                append( sb, "Database profile: [derby, mssql, mysql, oracle, postgresql].", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcDriver", 2 );
                append( sb, "Database driver.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcPassword (Default: sonar)", 2 );
                append( sb, "Database password.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcUrl", 2 );
                append( sb, "Database URL.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcUsername (Default: sonar)", 2 );
                append( sb, "Database username.", 3 );
                append( sb, "", 0 );

                append( sb, "mavenHome (Default: ${maven.home})", 2 );
                append( sb, "Maven home directory.", 3 );
                append( sb, "", 0 );

                append( sb, "messageLevel (Default: info)", 2 );
                append( sb, "The message-level used to tune the verbosity of Ant logging.", 3 );
                append( sb, "", 0 );

                append( sb, "projectsDir (Default: ${basedir})", 2 );
                append( sb, "Directory containing projects.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "sonar-dev:help", 0 );
            append( sb, "Display help information on sonar-dev-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0sonar-dev:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "start".equals( goal ) )
        {
            append( sb, "sonar-dev:start", 0 );
            append( sb, "Start Sonar.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "background (Default: false)", 2 );
                append( sb, "Set to true to run Sonar in background mode.", 3 );
                append( sb, "", 0 );

                append( sb, "basedir (Default: ${basedir})", 2 );
                append( sb, "The base directory from which to execute the Ant script.", 3 );
                append( sb, "", 0 );

                append( sb, "clean (Default: true)", 2 );
                append( sb, "Set to false to prevent clean installation.", 3 );
                append( sb, "", 0 );

                append( sb, "configBackup", 2 );
                append( sb, "File from where Sonar configuration should be restored.", 3 );
                append( sb, "", 0 );

                append( sb, "copyPluginArtifact (Default: true)", 2 );
                append( sb, "Should copy plugin artifact in Sonar plugins ?", 3 );
                append( sb, "", 0 );

                append( sb, "database (Default: derby)", 2 );
                append( sb, "Database profile: [derby, mssql, mysql, oracle, postgresql].", 3 );
                append( sb, "", 0 );

                append( sb, "dropDatabase (Default: false)", 2 );
                append( sb, "Set to true to drop database.", 3 );
                append( sb, "", 0 );

                append( sb, "extensionsDir (Default: ${project.build.directory}/extensions)", 2 );
                append( sb, "Directory from where extensions should be copied.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcDriver", 2 );
                append( sb, "Database driver.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcPassword (Default: sonar)", 2 );
                append( sb, "Database password.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcRootPassword", 2 );
                append( sb, "Database root password. Used when dropDatabase is true.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcRootUrl", 2 );
                append( sb, "Database root URL. Used when dropDatabase is true.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcRootUsername", 2 );
                append( sb, "Database root username. Used when dropDatabase is true.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcUrl", 2 );
                append( sb, "Database URL.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcUsername (Default: sonar)", 2 );
                append( sb, "Database username.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "Local Maven repository.", 3 );
                append( sb, "", 0 );

                append( sb, "messageLevel (Default: info)", 2 );
                append( sb, "The message-level used to tune the verbosity of Ant logging.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifact (Default: ${project.build.directory}/${project.build.finalName}.jar)", 2 );
                append( sb, "Plugin to install.", 3 );
                append( sb, "", 0 );

                append( sb, "runtimeVersion", 2 );
                append( sb, "Sonar version.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "start-war".equals( goal ) )
        {
            append( sb, "sonar-dev:start-war", 0 );
            append( sb, "Starts Sonar WAR.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "background (Default: false)", 2 );
                append( sb, "Set to true to run Sonar in background mode.", 3 );
                append( sb, "", 0 );

                append( sb, "basedir (Default: ${basedir})", 2 );
                append( sb, "The base directory from which to execute the Ant script.", 3 );
                append( sb, "", 0 );

                append( sb, "clean (Default: true)", 2 );
                append( sb, "Set to false to prevent clean installation.", 3 );
                append( sb, "", 0 );

                append( sb, "configBackup", 2 );
                append( sb, "File from where Sonar configuration should be restored.", 3 );
                append( sb, "", 0 );

                append( sb, "copyPluginArtifact (Default: true)", 2 );
                append( sb, "Should copy plugin artifact in Sonar plugins ?", 3 );
                append( sb, "", 0 );

                append( sb, "database (Default: derby)", 2 );
                append( sb, "Database profile: [derby, mssql, mysql, oracle, postgresql].", 3 );
                append( sb, "", 0 );

                append( sb, "dropDatabase (Default: false)", 2 );
                append( sb, "Set to true to drop database.", 3 );
                append( sb, "", 0 );

                append( sb, "extensionsDir (Default: ${project.build.directory}/extensions)", 2 );
                append( sb, "Directory from where extensions should be copied.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcDriver", 2 );
                append( sb, "Database driver.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcPassword (Default: sonar)", 2 );
                append( sb, "Database password.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcRootPassword", 2 );
                append( sb, "Database root password. Used when dropDatabase is true.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcRootUrl", 2 );
                append( sb, "Database root URL. Used when dropDatabase is true.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcRootUsername", 2 );
                append( sb, "Database root username. Used when dropDatabase is true.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcUrl", 2 );
                append( sb, "Database URL.", 3 );
                append( sb, "", 0 );

                append( sb, "jdbcUsername (Default: sonar)", 2 );
                append( sb, "Database username.", 3 );
                append( sb, "", 0 );

                append( sb, "localRepository", 2 );
                append( sb, "Local Maven repository.", 3 );
                append( sb, "", 0 );

                append( sb, "messageLevel (Default: info)", 2 );
                append( sb, "The message-level used to tune the verbosity of Ant logging.", 3 );
                append( sb, "", 0 );

                append( sb, "pluginArtifact (Default: ${project.build.directory}/${project.build.finalName}.jar)", 2 );
                append( sb, "Plugin to install.", 3 );
                append( sb, "", 0 );

                append( sb, "runtimeVersion", 2 );
                append( sb, "Sonar version.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stop".equals( goal ) )
        {
            append( sb, "sonar-dev:stop", 0 );
            append( sb, "Stop Sonar.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir (Default: ${basedir})", 2 );
                append( sb, "The base directory from which to execute the Ant script.", 3 );
                append( sb, "", 0 );

                append( sb, "messageLevel (Default: info)", 2 );
                append( sb, "The message-level used to tune the verbosity of Ant logging.", 3 );
                append( sb, "", 0 );

                append( sb, "runtimeVersion", 2 );
                append( sb, "Sonar version.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "stop-war".equals( goal ) )
        {
            append( sb, "sonar-dev:stop-war", 0 );
            append( sb, "Stops Sonar WAR.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "basedir (Default: ${basedir})", 2 );
                append( sb, "The base directory from which to execute the Ant script.", 3 );
                append( sb, "", 0 );

                append( sb, "messageLevel (Default: info)", 2 );
                append( sb, "The message-level used to tune the verbosity of Ant logging.", 3 );
                append( sb, "", 0 );

                append( sb, "runtimeVersion", 2 );
                append( sb, "Sonar version", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "trim".equals( goal ) )
        {
            append( sb, "sonar-dev:trim", 0 );
            append( sb, "(no description available)", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "directory", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "List of ant-style patterns. If this is not specified, allfiles in the project source directories are included.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceEncoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "Specifies the encoding of the source files.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
