/*
 * Sonar, open source software quality management tool.
 * Copyright (C) 2009 SonarSource SA
 * mailto:contact AT sonarsource DOT com
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.gwt.ui;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.sonar.wsclient.gwt.unmarshallers.ResourceUnmarshaller;
import org.sonar.wsclient.services.Resource;

public abstract class Page implements EntryPoint {

  private Widget currentWidget = null;
  private Integer currentResourceId = null;

  public final void onModuleLoad() {
    export(GWT.getModuleName(), this);
    load();
    onResourceLoad();
  }

  private void load() {
    Widget widget = doOnModuleLoad();
    if (widget!=null) {
      getRootPanel().add(widget);
    }
  }

  protected Widget doOnModuleLoad() {
    return null;
  }

  public final void onResourceLoad() {
    JavaScriptObject json = loadResource();
    if (json != null) {
      Resource resource = ResourceUnmarshaller.getInstance().toModel(json);

      RootPanel container = getRootPanel();
      container.clear();
      if (resource.getId().equals(currentResourceId) && currentWidget != null) {
        container.add(currentWidget);

      } else {
        currentWidget = doOnResourceLoad(resource);
        currentResourceId = resource.getId();
        if (currentWidget != null) {
          container.add(currentWidget);
        }
      }
    }
  }

  protected Widget doOnResourceLoad(Resource resource) {
    return null;
  }

  protected final RootPanel getRootPanel() {
    RootPanel result = RootPanel.get("gwtpage-" + GWT.getModuleName());
    if (result == null) {
      result = RootPanel.get("gwtpage");
    }
    return result;
  }

  private native JavaScriptObject loadResource()/*-{
    return $wnd.config['resource'];
  }-*/;

  private native void export(String gwtId, Page page)/*-{
    $wnd.modules[gwtId]=function() {page.@org.sonar.gwt.ui.Page::onResourceLoad()()};
  }-*/;
}

