/*
 * Sonar, entreprise quality control tool.
 * Copyright (C) 2007-2008 Hortis-GRC SA
 * mailto:be_agile HAT hortis DOT ch
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.plugins.api.web.gwt.client;

import com.google.gwt.core.client.JavaScriptObject;

public class JsonUtils {
  private static int requestId = 0;

  public interface JSONHandler {
    void handleJSON(JavaScriptObject obj);
  }

  /**
   * IMPORTANT : the url should ended with ?callback= or &callback=
   */
  public static void requestJson(String url, JSONHandler handler) {
    makeJSONRequest(requestId++, url, handler);
  }

  public static native void makeJSONRequest(int requestId, String url, JSONHandler handler) /*-{
      var callback = "callback" + requestId;

      // create SCRIPT tag, and set SRC attribute equal to JSON feed URL + callback function name
      var script = document.createElement("script");
      script.setAttribute("src", url+callback);
      script.setAttribute("type", "text/javascript");

      window[callback] = function(jsonObj) {
        @org.sonar.plugins.api.web.gwt.client.JsonUtils::dispatchJSON(Lcom/google/gwt/core/client/JavaScriptObject;Lorg/sonar/plugins/api/web/gwt/client/JsonUtils$JSONHandler;)(jsonObj, handler);
        window[callback + "done"] = true;
      }

      setTimeout(function() {
        if (!window[callback + "done"]) {
          handler.@org.sonar.plugins.api.web.gwt.client.JsonUtils.JSONHandler::handleJSON(Lcom/google/gwt/core/client/JavaScriptObject;)(null);
        }

        // cleanup
        document.body.removeChild(script);
        if (window[callback]) {
          delete window[callback];
        }
        if (window[callback + "done"]) {
          delete window[callback + "done"];
        }
      }, 60000);

      document.body.appendChild(script);
    }-*/;

  public static void dispatchJSON(JavaScriptObject jsonObj, JSONHandler handler) {
    handler.handleJSON(jsonObj);
  }

}
