/*
 * Sonar, entreprise quality control tool.
 * Copyright (C) 2007-2008 Hortis-GRC SA
 * mailto:be_agile HAT hortis DOT ch
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.plugins.api.web.gwt.client;

import com.google.gwt.user.client.ui.Widget;

public class LineDecorator {
    private String sourceStyle;
    private String value;
    private String valueStyle;
    private Widget message;

    public LineDecorator() {
      valueStyle = null;
      value = null;
      sourceStyle = null;
    }

    public LineDecorator(String sourceStyle, String value, String valueStyle, Widget message) {
      this.sourceStyle = null;
      this.sourceStyle = sourceStyle;
      this.value = null;
      this.value = value;
      this.message = message;
      this.valueStyle = null;
      this.valueStyle = valueStyle;
    }

    public String getValueStyle() {
      return valueStyle;
    }

    public void setValueStyle(String valueStyle) {
      this.valueStyle = valueStyle;
    }

    public String getSourceStyle() {
      return sourceStyle;
    }

    public void setSourceStyle(String sourceStyle) {
      this.sourceStyle = sourceStyle;
    }

    public String getValue() {
      return value;
    }

    public void setValue(String value) {
      this.value = value;
    }

    public Widget getMessage() {
      return message;
    }

    public void setMessage(Widget details) {
      this.message = details;
    }

    public String toString(){
      return " [value : " + value + "] ";
    }
}
