/*
 * Sonar, entreprise quality control tool.
 * Copyright (C) 2007-2008 Hortis-GRC SA
 * mailto:be_agile HAT hortis DOT ch
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.plugins.api.web.gwt.client;

import com.google.gwt.i18n.client.Dictionary;

import java.util.MissingResourceException;

public class Utils {

  public static String getConfiguration(String key) {
    Dictionary config = Dictionary.getDictionary("config");
    if (config != null) {
      try {
      return config.get(key);
      } catch (MissingResourceException e) {
        return null;
      }
    }
    return null;
  }

  public static String getServerUrl() {
    return getConfiguration("sonar_url");
  }

  public static native void showError(String message) /*-{
    $wnd.error(message);
  }-*/;

  public static native void showWarning(String message) /*-{
    $wnd.warning(message);
  }-*/;

  public static native void showInfo(String message) /*-{
    $wnd.info(message);
  }-*/;

}


