/*
 * Sonar, entreprise quality control tool.
 * Copyright (C) 2007-2008 Hortis-GRC SA
 * mailto:be_agile HAT hortis DOT ch
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.plugins.api.web.gwt.client.rest;

import com.google.gwt.json.client.*;
import org.sonar.plugins.api.web.gwt.client.rest.model.Measure;
import org.sonar.plugins.api.web.gwt.client.rest.model.Parameter;
import org.sonar.plugins.api.web.gwt.client.rest.model.Project;
import org.sonar.plugins.api.web.gwt.client.rest.model.Snapshot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RestUtils {

  public ArrayList<Project> processResponse(JSONArray array) {
    ArrayList<Project> projects = new ArrayList<Project>();
    for (int i = 0; i < array.size(); i++) {
      JSONObject jsStock;
      if ((jsStock = array.get(i).isObject()) == null) continue;
      Project project = processProject(jsStock);
      projects.add(project);
    }
    return projects;
  }

  public boolean hasProjectAtLeastOneMeasure(List<Project> projects) {
    if (!projects.isEmpty()) {
      Project project = projects.get(0);
      List<Snapshot> snapshots = project.getSnapshots();
      if (snapshots != null && !snapshots.isEmpty()) {
        Map<String, Measure> measures = snapshots.get(0).getMeasures();
        if (measures != null && measures.size() >= 1) {
          return true;
        }
      }
    }
    return false;
  }

  private Project processProject(JSONObject jsStock) {
    JSONValue jsonValue;
    JSONNumber id = null;
    JSONString key = null;
    JSONString name = null;
    JSONString qualifier = null;

    jsonValue = null;

    if ((jsonValue = jsStock.get("id")) != null) {
      id = jsonValue.isNumber();
    }

    if ((jsonValue = jsStock.get("key")) != null) {
      key = jsonValue.isString();
    }

    if ((jsonValue = jsStock.get("name")) != null) {
      name = jsonValue.isString();
    }

    if ((jsonValue = jsStock.get("qualifier")) != null) {
      qualifier = jsonValue.isString();
    }

    ArrayList<Snapshot> snapshots = null;
    if ((jsonValue = jsStock.get("measures")) != null) {
      JSONArray measures = jsonValue.isArray();

      snapshots = processSnapshots(measures);
    }
    return new Project((int)id.doubleValue(), key.stringValue(), name.stringValue(), qualifier.stringValue(), snapshots);
  }

  private ArrayList<Snapshot> processSnapshots(JSONArray measures) {
    JSONValue jsonValue;
    JSONObject jsStock;
    JSONString date = null;
    JSONArray msr;
    ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
    Map<String, Measure> projectMeasures = null;

    for (int i = 0; i < measures.size(); i++) {
      if ((jsStock = measures.get(i).isObject()) == null) continue;

      if ((jsonValue = jsStock.get("date")) != null) {
        date = jsonValue.isString();
      }

      if (jsStock.get("msr") != null && (msr = jsStock.get("msr").isArray()) != null) {
        projectMeasures = processMeasures(msr);
      }

      snapshots.add(new Snapshot(date.stringValue(), projectMeasures));
    }

    return snapshots;
  }

  private Map<String, Measure> processMeasures(JSONArray msr) {
    JSONValue jsonValue;
    JSONObject jsMsr;
    JSONArray parameters;
    Map<String, Measure> projectMeasures = new HashMap<String, Measure>();
    for (int j = 0; j < msr.size(); j++) {
      if ((jsMsr = msr.get(j).isObject()) == null) continue;

      JSONString metric, metricName = null, val, f_val;

      if ((jsonValue = jsMsr.get("metric")) == null) continue;
      if ((metric = jsonValue.isString()) == null) continue;

      JSONValue metricNameJson = jsMsr.get("metric_name");
      if (metricNameJson != null) {
        metricName = metricNameJson.isString();
      }

      if ((jsonValue = jsMsr.get("value")) == null) continue;
      if ((val = jsonValue.isString()) == null) continue;

      if ((jsonValue = jsMsr.get("f_value")) == null) continue;
      if ((f_val = jsonValue.isString()) == null) continue;

      Map<String, Parameter> measureParameters = null;
      if ((jsonValue = jsMsr.get("prm")) != null) {
        if ((parameters = jsonValue.isArray()) != null) {
          measureParameters = processMeasureParameters(parameters);
        }
      }

      Measure measure = new Measure(metric.stringValue(), val.stringValue(), f_val.stringValue(), measureParameters);
      if (metricName != null) {
        measure.setMetricName(metricName.stringValue());
      }
      projectMeasures.put(metric.stringValue(), measure);
    }
    return projectMeasures;
  }

  private Map<String, Parameter> processMeasureParameters(JSONArray parameters) {
    JSONValue jsonValue;
    JSONObject jsParameters;

    Map<String, Parameter> measureParameters = new HashMap<String, Parameter>();
    for (int k = 0; k < parameters.size(); k++) {
      if ((jsParameters = parameters.get(k).isObject()) == null) continue;

      JSONString prmKey, prmVal;

      if ((jsonValue = jsParameters.get("key")) == null) continue;
      if ((prmKey = jsonValue.isString()) == null) continue;

      if ((jsonValue = jsParameters.get("val")) == null) continue;
      if ((prmVal = jsonValue.isString()) == null) continue;

      measureParameters.put(prmKey.stringValue(), new Parameter(prmKey.stringValue(), prmVal.stringValue(), null, null));
    }

    return measureParameters;
  }

}