/*
 * Sonar, entreprise quality control tool.
 * Copyright (C) 2007-2008 Hortis-GRC SA
 * mailto:be_agile HAT hortis DOT ch
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.plugins.api.web.gwt.client.rest.model;

import java.util.Map;

public class Measure {

  private String metric;
  private String metricName;
  private String value;
  private String formattedValue;
  private Map<String, Parameter> parameters;

  public Measure() {
  }

  public Measure(String metric, String value, String formattedValue, Map<String, Parameter> parameters) {
    this.metric = metric;
    this.value = value;
    this.formattedValue = formattedValue;
    this.parameters = parameters;
  }

  public String getMetric() {
    return metric;
  }

  public void setMetric(String metric) {
    this.metric = metric;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getFormattedValue() {
    return formattedValue;
  }

  public void setFormattedValue(String formattedValue) {
    this.formattedValue = formattedValue;
  }

  public Map<String, Parameter> getParameters() {
    return parameters;
  }

  public void setParameters(Map<String, Parameter> parameters) {
    this.parameters = parameters;
  }

  public String getMetricName() {
    return metricName;
  }

  public void setMetricName(String metricName) {
    this.metricName = metricName;
  }

  public String toString() {
    return "Measure{" +
      "metric='" + metric + '\'' +
      ", metric_name='" + metricName + '\'' +
      ", val='" + value + '\'' +
      ", f_val='" + formattedValue + '\'' +
      ", parameters=" + parameters +
      '}';
  }


}
