/*
 * Sonar, entreprise quality control tool.
 * Copyright (C) 2007-2008 Hortis-GRC SA
 * mailto:be_agile HAT hortis DOT ch
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.plugins.api.web.gwt.client.rest.model;

import java.util.ArrayList;

public class Project {

  private Integer id;
  private String key;
  private String name;
  private String qualifier;
  private ArrayList<Link> links;
  private ArrayList<Snapshot> snapshots;

  public Project() {
  }

  public Project(Integer id, String key, String name, String qualifier, ArrayList<Snapshot> snapshots) {
    this.id = id;
    this.key = key;
    this.name = name;
    this.qualifier = qualifier;
    this.snapshots = snapshots;
  }

  public Integer getId() {
    return id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getQualifier() {
    return qualifier;
  }

  public void setQualifier(String qualifier) {
    this.qualifier = qualifier;
  }

  public ArrayList<Snapshot> getSnapshots() {
    return snapshots;
  }

  public void setSnapshots(ArrayList<Snapshot> snapshots) {
    this.snapshots = snapshots;
  }

  public ArrayList<Link> getLinks() {
    return links;
  }

  public void setLinks(ArrayList<Link> links) {
    this.links = links;
  }

  public String toString() {
    return "Project{" +
        "id='" + id + '\'' +
        ", key='" + key + '\'' +
        ", name='" + name + '\'' +
        ", qualifier='" + qualifier + '\'' +
        ", links=" + links +
        ", snapshots=" + snapshots +
        '}';
  }
}
