/*
 * Sonar, entreprise quality control tool.
 * Copyright (C) 2007-2008 Hortis-GRC SA
 * mailto:be_agile HAT hortis DOT ch
 *
 * Sonar is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * Sonar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sonar; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.plugins.api.web.gwt.client.rest.model;

import java.util.Map;

public class Snapshot {

  private String date;
  private Map<String, Measure> measures;

  public Snapshot() {
  }

  public Snapshot(String date, Map<String, Measure> measures) {
    this.date = date;
    this.measures = measures;
  }

  public String getDate() {
    return date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  public Map<String, Measure> getMeasures() {
    return measures;
  }

  public void setMeasures(Map<String, Measure> measures) {
    this.measures = measures;
  }

  public String toString() {
    return "Snapshot{" +
        "date='" + date + '\'' +
        ", measures=" + measures +
        '}';
  }

}