/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api;

import ch.hortis.sonar.model.MavenProject;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.plugins.api.JavaLanguage;

public class JavaLanguageTest {
    private static final int ROOT_PROJECT_ID = 33;

    @Test
    public void testNewClass() {
        MavenProject myClass = JavaLanguage.newClass((String)"projectkey", (String)"my.package", (String)"MyClass.java", (boolean)false, (Integer)33);
        Assert.assertEquals((Object)"projectkey:my.package.MyClass", (Object)myClass.getKey());
        Assert.assertEquals((Object)"MyClass", (Object)myClass.getName());
        Assert.assertEquals((Object)"JMA", (Object)myClass.getQualifier());
        Assert.assertEquals((long)33L, (long)myClass.getRootId().intValue());
        Assert.assertEquals((Object)"CLA", (Object)myClass.getScope());
    }

    @Test
    public void unitTestShouldHaveItsOwnQualifier() {
        MavenProject myClass = JavaLanguage.newClass((String)"projectkey", (String)"my.package", (String)"MyClass.java", (boolean)true, (Integer)33);
        Assert.assertEquals((Object)"projectkey:my.package.MyClass", (Object)myClass.getKey());
        Assert.assertEquals((Object)"MyClass", (Object)myClass.getName());
        Assert.assertEquals((Object)"JUN", (Object)myClass.getQualifier());
        Assert.assertEquals((long)33L, (long)myClass.getRootId().intValue());
        Assert.assertEquals((Object)"CLA", (Object)myClass.getScope());
    }

    @Test
    public void testNewPackage() {
        MavenProject myPackage = JavaLanguage.newPackage((String)"projectkey", (String)"my.package", (Integer)33);
        Assert.assertEquals((Object)"projectkey:my.package", (Object)myPackage.getKey());
        Assert.assertEquals((Object)"my.package", (Object)myPackage.getName());
        Assert.assertEquals((Object)"JAV", (Object)myPackage.getQualifier());
        Assert.assertEquals((long)33L, (long)myPackage.getRootId().intValue());
        Assert.assertEquals((Object)"PAC", (Object)myPackage.getScope());
    }

    @Test
    public void defaultPackageShouldBeAPackageLikeOthers() {
        this.checkDefaultPackage(null);
        this.checkDefaultPackage("");
        this.checkDefaultPackage("  ");
        MavenProject clazz = JavaLanguage.newClass((String)"myproject", null, (String)"MyClass", (boolean)false, (Integer)33);
        Assert.assertEquals((Object)"myproject:[default].MyClass", (Object)clazz.getKey());
    }

    @Test
    public void aClassShouldNotBeSuffixedByDotJava() {
        MavenProject clazz = JavaLanguage.newClass((String)"myproject", (String)"my.package", (String)"MyClass.java", (boolean)false, (Integer)33);
        Assert.assertEquals((Object)"MyClass", (Object)clazz.getName());
        Assert.assertEquals((Object)"myproject:my.package.MyClass", (Object)clazz.getKey());
    }

    @Test
    public void aClassShouldBeTrimmed() {
        MavenProject clazz = JavaLanguage.newClass((String)"myproject", (String)"my.package", (String)" MyClass  ", (boolean)false, (Integer)33);
        Assert.assertEquals((Object)"MyClass", (Object)clazz.getName());
        Assert.assertEquals((Object)"myproject:my.package.MyClass", (Object)clazz.getKey());
    }

    private void checkDefaultPackage(String packageName) {
        MavenProject pack = JavaLanguage.newPackage((String)"myproject", (String)packageName, (Integer)33);
        Assert.assertEquals((Object)"[default]", (Object)pack.getName());
        Assert.assertEquals((Object)"myproject:[default]", (Object)pack.getKey());
    }
}

