/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.charts;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;
import org.apache.commons.io.FileUtils;
import org.jfree.chart.ChartUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.junit.Assert;

public abstract class AbstractChartTest {
    protected void assertChartSizeGreaterThan(BufferedImage img, int size) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ChartUtilities.writeBufferedImageAsPNG((OutputStream)output, (BufferedImage)img);
        Assert.assertTrue((String)("PNG size in bits=" + output.size()), (output.size() > size ? 1 : 0) != 0);
    }

    protected void assertChartSizeLesserThan(BufferedImage img, int size) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ChartUtilities.writeBufferedImageAsPNG((OutputStream)output, (BufferedImage)img);
        Assert.assertTrue((String)("PNG size in bits=" + output.size()), (output.size() < size ? 1 : 0) != 0);
    }

    protected void saveChart(BufferedImage img, String name) throws IOException {
        File target = new File("target");
        FileUtils.forceMkdir((File)target);
        ByteArrayOutputStream imgOutput = new ByteArrayOutputStream();
        ChartUtilities.writeBufferedImageAsPNG((OutputStream)imgOutput, (BufferedImage)img);
        FileOutputStream out = new FileOutputStream(new File(target, name));
        ((OutputStream)out).write(imgOutput.toByteArray());
        ((OutputStream)out).close();
    }

    protected static void displayTestPanel(BufferedImage image) throws IOException {
        ApplicationFrame frame = new ApplicationFrame("testframe");
        BufferedPanel imgPanel = new BufferedPanel(image);
        frame.setContentPane((Container)imgPanel);
        frame.pack();
        RefineryUtilities.centerFrameOnScreen((Window)frame);
        frame.setVisible(true);
    }

    protected static Date stringToDate(String sDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yy hh'h'mm");
        return sdf.parse(sDate);
    }

    private static class BufferedPanel
    extends JPanel {
        private BufferedImage chartImage;

        public BufferedPanel(BufferedImage chartImage) {
            this.chartImage = chartImage;
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.chartImage, 0, 0, null);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.chartImage.getWidth(), this.chartImage.getHeight());
        }
    }
}

