/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.jobs;

import ch.hortis.sonar.model.Snapshot;
import java.util.List;
import javax.persistence.Query;
import org.picocontainer.containers.TransientPicoContainer;
import org.sonar.commons.database.AbstractDbUnitTestCase;
import org.sonar.commons.database.DatabaseManager;
import org.sonar.plugins.api.Languages;
import org.sonar.plugins.api.jobs.Job;
import org.sonar.plugins.api.jobs.Resource;
import org.sonar.plugins.api.jobs.ResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJobTestCase
extends AbstractDbUnitTestCase {
    protected DatabaseManager databaseManager;
    protected Job job;

    protected void initialize(Class jobClass) {
        this.databaseManager = this.getDatabaseManager();
        this.job = this.createInstance(jobClass);
    }

    private Job createInstance(Class jobClass) {
        try {
            TransientPicoContainer pico = new TransientPicoContainer();
            pico.addComponent((Object)this.getDao());
            pico.addComponent((Object)jobClass);
            pico.start();
            return (Job)pico.getComponent(jobClass);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create instance of " + jobClass.getName(), e);
        }
    }

    protected Snapshot getSnapshot(int id) {
        Query query = this.databaseManager.createQuery("SELECT s FROM Snapshot s WHERE s.id=:id");
        query.setParameter("id", (Object)id);
        return (Snapshot)query.getSingleResult();
    }

    protected List<Snapshot> getChildrenSnapshot(Snapshot snapshot) {
        Query query = this.databaseManager.createQuery("SELECT s FROM Snapshot s WHERE s.parent = :parent");
        query.setParameter("parent", (Object)snapshot);
        return query.getResultList();
    }

    protected ResourceImpl loadNode(Snapshot snapshot) {
        ResourceImpl node = new ResourceImpl(snapshot, this.getDao());
        for (Snapshot childSnapshot : this.getChildrenSnapshot(snapshot)) {
            ResourceImpl child = new ResourceImpl(childSnapshot, this.getDao());
            node.keepChild(child);
        }
        return node;
    }

    protected void assertProcess(String fixtureName, int snapshotId, String ... tablesToCheck) {
        this.setupData(new String[]{"sharedFixture", fixtureName});
        Snapshot rootSnapshot = this.getSnapshot(snapshotId);
        this.job.execute((Resource)this.loadNode(rootSnapshot));
        this.databaseManager.stop();
        this.checkTables(fixtureName, tablesToCheck);
    }

    protected void assertProcess(String fixtureName, int snapshotId) {
        this.assertProcess(fixtureName, snapshotId, "project_measures");
    }

    protected Resource aParentNode() {
        return this.aPackage();
    }

    protected Resource aLeaf() {
        return this.aMainClass();
    }

    protected Resource aTestClass() {
        Snapshot snapshot = new Snapshot();
        snapshot.setScope("CLA");
        snapshot.setQualifier("JUN");
        return new ResourceImpl(snapshot, this.getDao());
    }

    protected Resource aMainClass() {
        Snapshot snapshot = new Snapshot();
        snapshot.setScope("CLA");
        snapshot.setQualifier("JMA");
        return new ResourceImpl(snapshot, this.getDao());
    }

    protected Resource aPackage() {
        Snapshot snapshot = new Snapshot();
        snapshot.setScope("PAC");
        return new ResourceImpl(snapshot, this.getDao());
    }

    protected Resource aModule() {
        Snapshot snapshot = new Snapshot();
        snapshot.setScope("PRJ");
        ResourceImpl root = (ResourceImpl)this.aProject();
        snapshot.setParent(root.getSnapshot());
        snapshot.setRoot(root.getSnapshot());
        ResourceImpl result = new ResourceImpl(snapshot, this.getDao());
        root.keepChild(result);
        return result;
    }

    protected Resource aProject() {
        Snapshot snapshot = new Snapshot();
        snapshot.setScope("PRJ");
        snapshot.setParent(null);
        snapshot.setRoot(null);
        return new ResourceImpl(snapshot, this.getDao());
    }

    protected Resource aJavaProject() {
        Snapshot snapshot = new Snapshot();
        snapshot.setScope("PRJ");
        snapshot.setQualifier(Languages.JAVA.getProjectQualifier());
        snapshot.setParent(null);
        snapshot.setRoot(null);
        return new ResourceImpl(snapshot, this.getDao());
    }
}

