/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.jobs;

import ch.hortis.sonar.model.Metric;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.plugins.api.Language;
import org.sonar.plugins.api.jobs.AbstractJobTestCase;
import org.sonar.plugins.api.jobs.AbstractWeightingJob;
import org.sonar.plugins.api.jobs.Resource;
import org.sonar.plugins.api.metrics.CoreMetrics;

public class AbstractWeightingJobTest
extends AbstractJobTestCase {
    private static final int SNAPSHOT_ID = 1;

    @Before
    public void before() throws Exception {
        this.initialize(FakeWeightingJob.class);
    }

    @Test
    public void shouldExecuteWhenSnapshotIsNotTest() {
        Assert.assertTrue((String)"Should execute when snapshot is main class", (boolean)this.job.shouldExecuteOnResource(this.aMainClass()));
        Assert.assertTrue((String)"Should execute when snapshot is package", (boolean)this.job.shouldExecuteOnResource(this.aPackage()));
    }

    @Test
    public void shouldInsertWeightMeasure() throws Exception {
        this.assertProcess("shouldInsertWeightMeasure", 1);
    }

    @Test
    public void shouldDoNothingWhenDivideByZero() throws Exception {
        this.assertProcess("shouldDoNothingWhenDivideByZero", 1);
    }

    @Test
    public void shouldDoNothingWhenNoData() throws Exception {
        this.assertProcess("shouldDoNothingWhenNoData", 1);
    }

    protected static class FakeWeightingJob
    extends AbstractWeightingJob {
        protected Metric getTargetMetric() {
            return CoreMetrics.COMPLEXITY_AVG_BY_CLASS;
        }

        protected Metric getDivisorMetric() {
            return CoreMetrics.CLASSES_COUNT;
        }

        protected Metric getDividendMetric() {
            return CoreMetrics.COMPLEXITY;
        }

        public boolean shouldExecuteOnResource(Resource resource) {
            return true;
        }

        protected Language shouldExecuteOnLanguage() {
            return null;
        }
    }
}

