/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.maven;

import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.RuleFailureLevel;
import ch.hortis.sonar.model.RuleFailureParam;
import ch.hortis.sonar.model.Snapshot;
import ch.hortis.sonar.service.MeasureKey;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.commons.database.AbstractDbUnitTestCase;
import org.sonar.commons.measures.Measure;
import org.sonar.commons.measures.MeasureParameter;
import org.sonar.plugins.api.maven.JavaMeasuresRecorder;

public class JavaMeasuresRecorderTest
extends AbstractDbUnitTestCase {
    private JavaMeasuresRecorder recorder = null;

    @Before
    public void before() throws Exception {
        this.recorder = new JavaMeasuresRecorder(this.getDao());
    }

    @After
    public void after() {
        this.recorder = null;
    }

    @Test
    public void createClassMeasuresWhenNoPackageMeasures() throws Exception {
        this.setupData(new String[]{"createClassMeasuresWhenNoPackageMeasures"});
        this.recorder.setRootSnapshot(this.getDao().getMeasuresDao().getSnapshot(1));
        this.recorder.createClassMeasure("my.package", "MyClass", false, new MeasureKey(this.getTestMetric()), Double.valueOf(10.2), new MeasureParameter[0]);
        this.stopDao();
        this.checkTables("createClassMeasuresWhenNoPackageMeasures", new String[]{"projects", "snapshots", "project_measures"});
    }

    @Test
    public void createPackageThenClassMeasures() throws Exception {
        this.setupData(new String[]{"createPackageThenClassMeasures"});
        this.recorder.setRootSnapshot(this.getDao().getMeasuresDao().getSnapshot(1));
        this.recorder.createPackageMeasure("my.package", new MeasureKey(this.getTestMetric()), Double.valueOf(100.8));
        this.recorder.createClassMeasure("my.package", "MyClass", false, new MeasureKey(this.getTestMetric()), Double.valueOf(10.2), new MeasureParameter[0]);
        this.stopDao();
        this.checkTables("createPackageThenClassMeasures", new String[]{"projects", "snapshots", "project_measures"});
    }

    @Test
    public void createManyMeasures() throws Exception {
        this.setupData(new String[]{"createManyMeasures"});
        Snapshot root = this.getDao().getMeasuresDao().getSnapshot(1);
        this.recorder.setRootSnapshot(root);
        for (int i = 0; i < 150; ++i) {
            this.recorder.createClassMeasure("my.package" + i, "MyClass" + i, false, new MeasureKey(this.getSecondTestMetric()), Double.valueOf((double)i * 2.0), new MeasureParameter[0]);
            this.recorder.createClassMeasure("my.package" + i, "MySecondClass" + i, false, new MeasureKey(this.getSecondTestMetric()), Double.valueOf((double)i * 2.0), new MeasureParameter[0]);
        }
        this.recorder.createProjectMeasure(new MeasureKey(this.getTestMetric()), Double.valueOf(1000.0));
        this.stopDao();
        List childs = this.getDao().getMeasuresDao().getChildSnapshots(root, true);
        Assert.assertEquals((long)450L, (long)childs.size());
    }

    @Test
    public void sameClassInTwoDifferentProjects() throws Exception {
        this.setupData(new String[]{"sameClassInTwoDifferentProjects"});
        this.recorder.setRootSnapshot(this.getDao().getMeasuresDao().getSnapshot(2));
        this.recorder.createProjectMeasure(new MeasureKey(this.getTestMetric()), Double.valueOf(999.2));
        this.stopDao();
        this.checkTables("sameClassInTwoDifferentProjects", new String[]{"projects", "snapshots", "project_measures"});
    }

    @Test
    public void createRuleFailures() throws Exception {
        this.setupData(new String[]{"createRuleFailures"});
        this.recorder.setRootSnapshot(this.getDao().getMeasuresDao().getSnapshot(1));
        RuleFailureParam param1 = new RuleFailureParam("line", Double.valueOf(20.0), null);
        RuleFailureParam param2 = new RuleFailureParam("column", Double.valueOf(10.0), null);
        this.recorder.createClassRuleFailure(this.getDao().getRulesDao().getRule("checkstyle", "rule1"), "my.package", "MyClass", false, "my message", RuleFailureLevel.ERROR, new RuleFailureParam[]{param1, param2, null});
        this.stopDao();
        this.checkTables("createRuleFailures", new String[]{"projects", "rules", "snapshots", "rule_failures", "rule_failure_params"});
    }

    @Test
    public void classesShouldNotBeSuffixedByDotJava() {
        this.setupData(new String[]{"classesShouldNotBeSuffixedByDotJava"});
        this.recorder.setRootSnapshot(this.getDao().getMeasuresDao().getSnapshot(1));
        Measure measure1 = this.recorder.createClassMeasure("my.package", "MyClass.java", false, new MeasureKey(this.getTestMetric()), Double.valueOf(10.0), new MeasureParameter[0]);
        Measure measure2 = this.recorder.createClassMeasure("my.package", "MyClass.JAVA", false, new MeasureKey(this.getTestMetric()), Double.valueOf(20.0), new MeasureParameter[0]);
        this.stopDao();
        Snapshot snapshot = this.getDao().getMeasuresDao().getSnapshot(measure1.getSnapshotId().intValue());
        Assert.assertEquals((Object)"MyClass", (Object)snapshot.getMavenProject().getName());
        Assert.assertTrue((boolean)snapshot.getMavenProject().getKey().endsWith("MyClass"));
        snapshot = this.getDao().getMeasuresDao().getSnapshot(measure2.getSnapshotId().intValue());
        Assert.assertEquals((Object)"MyClass", (Object)snapshot.getMavenProject().getName());
        Assert.assertTrue((boolean)snapshot.getMavenProject().getKey().endsWith("MyClass"));
    }

    private Metric getTestMetric() {
        return new Metric("packages_count");
    }

    private Metric getSecondTestMetric() {
        return new Metric("ncss");
    }
}

