/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.maven;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.plugins.api.maven.MavenCollectorUtils;

public class MavenCollectorUtilsTest {
    @Test
    public void onlyJavaClassesShouldBeReturned() {
        ArrayList<String> sourceDirs = new ArrayList<String>();
        sourceDirs.add("/home/project/src/main/java");
        String[] packageAndClass = MavenCollectorUtils.getJavaPackageAndClass((String)"/home/project/src/main/java/MyClass.html", sourceDirs);
        Assert.assertNull((Object)packageAndClass);
    }

    @Test
    public void defaultPackageShouldBeSetWhenClassHasNoPackage() {
        ArrayList<String> sourceDirs = new ArrayList<String>();
        sourceDirs.add("/home/project/src/main/java");
        String[] packageAndClass = MavenCollectorUtils.getJavaPackageAndClass((String)"/home/project/src/main/java/MyClass.java", sourceDirs);
        Assert.assertNull((Object)packageAndClass[0]);
        Assert.assertEquals((Object)"MyClass", (Object)packageAndClass[1]);
    }

    @Test
    public void shouldParseWindowsPath() {
        ArrayList<String> sourceDirs = new ArrayList<String>();
        sourceDirs.add("\\test\\src\\main\\java\\");
        String[] packageAndClass = MavenCollectorUtils.getJavaPackageAndClass((String)"\\test\\src\\main\\java\\org\\sonar\\MyClass.java", sourceDirs);
        Assert.assertEquals((Object)"org.sonar", (Object)packageAndClass[0]);
        Assert.assertEquals((Object)"MyClass", (Object)packageAndClass[1]);
    }

    @Test
    public void shouldParseManySourceDirs() {
        ArrayList<String> sourceDirs = new ArrayList<String>();
        sourceDirs.add("/project/src/test/java");
        sourceDirs.add("/project/src/main/java");
        String[] packageAndClass = MavenCollectorUtils.getJavaPackageAndClass((String)"/project/src/main/java/org/sonar/MyClass.java", sourceDirs);
        Assert.assertEquals((Object)"org.sonar", (Object)packageAndClass[0]);
        Assert.assertEquals((Object)"MyClass", (Object)packageAndClass[1]);
    }

    @Test
    public void shouldParseDirectoryAndFile() {
        String[] names = MavenCollectorUtils.getDirectoryAndFile((String)"C:\\CodeXpert\\PLSQL\\package_complexe.sql", (String)"C:\\CodeXpert\\PLSQL");
        Assert.assertNull((Object)names[0]);
        Assert.assertEquals((Object)"package_complexe.sql", (Object)names[1]);
        names = MavenCollectorUtils.getDirectoryAndFile((String)"C:\\CodeXpert\\PLSQL\\package_complexe.sql", (String)"C:\\CodeXpert\\");
        Assert.assertEquals((Object)"PLSQL", (Object)names[0]);
        Assert.assertEquals((Object)"package_complexe.sql", (Object)names[1]);
        names = MavenCollectorUtils.getDirectoryAndFile((String)"C:\\CodeXpert\\PLSQL\\package_complexe.sql", (String)"C:\\CodeXpert");
        Assert.assertEquals((Object)"PLSQL", (Object)names[0]);
        Assert.assertEquals((Object)"package_complexe.sql", (Object)names[1]);
        names = MavenCollectorUtils.getDirectoryAndFile((String)"C:\\CodeXpert\\PLSQL\\foo\\bar\\package_complexe.sql", (String)"C:\\CodeXpert\\PLSQL");
        Assert.assertEquals((Object)"foo/bar", (Object)names[0]);
        Assert.assertEquals((Object)"package_complexe.sql", (Object)names[1]);
        names = MavenCollectorUtils.getDirectoryAndFile((String)"C:\\CodeXpert\\PLSQL\\foo\\bar\\package_complexe.sql", (String)"C:/CodeXpert/PLSQL");
        Assert.assertEquals((Object)"foo/bar", (Object)names[0]);
        Assert.assertEquals((Object)"package_complexe.sql", (Object)names[1]);
        names = MavenCollectorUtils.getDirectoryAndFile((String)"C:\\CodeXpert\\PLSQL\\foo\\bar\\package_complexe.sql", (String)"C:/CodeXpert/PLSQL/");
        Assert.assertEquals((Object)"foo/bar", (Object)names[0]);
        Assert.assertEquals((Object)"package_complexe.sql", (Object)names[1]);
    }

    @Test
    public void shouldNotFailIfFileNotFound() {
        ArrayList<String> sourceDirs = new ArrayList<String>();
        sourceDirs.add("\\test\\src\\main\\java\\");
        String[] packageAndClass = MavenCollectorUtils.getJavaPackageAndClass((String)"\\other\\src\\other\\java\\org\\sonar\\MyClass.java", sourceDirs);
        Assert.assertNull((Object)packageAndClass);
    }
}

