/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.maven;

import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.sonar.plugins.api.maven.model.MavenPom;

public abstract class MavenTestCase {
    protected MavenPom readMavenProject(String pomUrlInClasspath) {
        MavenPom mavenPom;
        FileReader fileReader = null;
        try {
            File pomFile = new File(this.getClass().getResource(pomUrlInClasspath).toURI());
            MavenXpp3Reader pomReader = new MavenXpp3Reader();
            fileReader = new FileReader(pomFile);
            Model model = pomReader.read((Reader)fileReader);
            MavenProject project = new MavenProject(model);
            project.setFile(pomFile);
            mavenPom = new MavenPom(project);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to read Maven project file.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return mavenPom;
    }

    public Log getTestLog() {
        return new Log(){
            private PrintStream out = System.out;

            public void debug(CharSequence arg0) {
                this.out.println(arg0);
            }

            public void debug(Throwable arg0) {
                arg0.printStackTrace(this.out);
            }

            public void debug(CharSequence arg0, Throwable arg1) {
                this.out.println(arg0);
                arg1.printStackTrace(this.out);
            }

            public void error(CharSequence arg0) {
                this.out.println(arg0);
            }

            public void error(Throwable arg0) {
                arg0.printStackTrace(this.out);
            }

            public void error(CharSequence arg0, Throwable arg1) {
                this.out.println(arg0);
                arg1.printStackTrace(this.out);
            }

            public void info(CharSequence arg0) {
                this.out.println(arg0);
            }

            public void info(Throwable arg0) {
                arg0.printStackTrace(this.out);
            }

            public void info(CharSequence arg0, Throwable arg1) {
                this.out.println(arg0);
                arg1.printStackTrace(this.out);
            }

            public boolean isDebugEnabled() {
                return true;
            }

            public boolean isErrorEnabled() {
                return true;
            }

            public boolean isInfoEnabled() {
                return true;
            }

            public boolean isWarnEnabled() {
                return true;
            }

            public void warn(CharSequence arg0) {
                this.out.println(arg0);
            }

            public void warn(Throwable arg0) {
                arg0.printStackTrace(this.out);
            }

            public void warn(CharSequence arg0, Throwable arg1) {
                this.out.println(arg0);
                arg1.printStackTrace(this.out);
            }
        };
    }
}

