/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.maven;

import ch.hortis.sonar.model.MavenProject;
import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.model.Rule;
import ch.hortis.sonar.model.RuleFailure;
import ch.hortis.sonar.model.RuleFailureLevel;
import ch.hortis.sonar.model.RuleFailureParam;
import ch.hortis.sonar.model.Snapshot;
import ch.hortis.sonar.model.SnapshotSource;
import ch.hortis.sonar.service.MeasureKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.commons.measures.Measure;
import org.sonar.commons.measures.MeasureParameter;
import org.sonar.plugins.api.JavaLanguage;
import org.sonar.plugins.api.maven.JavaMeasuresRecorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockMeasuresRecorder
extends JavaMeasuresRecorder {
    private Set<MavenProject> packages = new HashSet<MavenProject>();
    private Set<MavenProject> classes = new HashSet<MavenProject>();
    private List<Measure> projectMeasures = new ArrayList<Measure>();
    private List<Measure> packageMeasures = new ArrayList<Measure>();
    private List<Measure> classMeasures = new ArrayList<Measure>();
    private List<RuleFailure> classRuleFailures = new ArrayList<RuleFailure>();
    private List<SnapshotSource> snapshotSources = new ArrayList<SnapshotSource>();
    private String projectKey;

    public MockMeasuresRecorder(String projectKey) {
        this.projectKey = projectKey;
    }

    public void start() {
    }

    public void stop() {
    }

    public Measure createProjectMeasure(MeasureKey key, Double value) {
        Measure m = new Measure(null, key, value);
        this.projectMeasures.add(m);
        return m;
    }

    public Measure createPackageMeasure(String packageName, MeasureKey key, Double value) {
        MavenProject entity = JavaLanguage.newPackage((String)this.projectKey, (String)packageName, null);
        this.packages.add(entity);
        Measure m = new Measure(new Snapshot(entity, false, null, null), key, value);
        this.packageMeasures.add(m);
        return m;
    }

    public Measure createClassMeasure(String packageName, String className, boolean unitTest, MeasureKey key, Double value, MeasureParameter ... parameters) {
        MavenProject packageEntity = JavaLanguage.newPackage((String)this.projectKey, (String)packageName, null);
        this.packages.add(packageEntity);
        MavenProject classEntity = JavaLanguage.newClass((String)this.projectKey, (String)packageName, (String)className, (boolean)unitTest, null);
        this.classes.add(classEntity);
        Measure m = new Measure(new Snapshot(classEntity, false, null, null), key, value);
        m.setParams(Arrays.asList(parameters));
        this.classMeasures.add(m);
        return m;
    }

    public RuleFailure createClassRuleFailure(Rule rule, String packageName, String className, boolean unitTest, String message, RuleFailureLevel level, RuleFailureParam ... params) {
        MavenProject packageEntity = JavaLanguage.newPackage((String)this.projectKey, (String)packageName, null);
        this.packages.add(packageEntity);
        MavenProject classEntity = JavaLanguage.newClass((String)this.projectKey, (String)packageName, (String)className, (boolean)unitTest, null);
        this.classes.add(classEntity);
        RuleFailure rf = new RuleFailure(rule, level, new Snapshot(classEntity, false, null, null));
        rf.setMessage(message);
        rf.setParameters(Arrays.asList(params));
        this.classRuleFailures.add(rf);
        return rf;
    }

    public SnapshotSource createClassSource(String packageName, String className, String source, boolean unitTest) {
        MavenProject packageEntity = JavaLanguage.newPackage((String)this.projectKey, (String)packageName, null);
        this.packages.add(packageEntity);
        MavenProject classEntity = JavaLanguage.newClass((String)this.projectKey, (String)packageName, (String)className, (boolean)unitTest, null);
        this.classes.add(classEntity);
        Snapshot snap = new Snapshot(classEntity, false, null, null);
        SnapshotSource src = new SnapshotSource(snap, source);
        this.snapshotSources.add(src);
        return src;
    }

    public Set<MavenProject> getPackages() {
        return this.packages;
    }

    public Set<MavenProject> getClasses() {
        return this.classes;
    }

    public List<SnapshotSource> getSnapshotSources() {
        return this.snapshotSources;
    }

    public List<Measure> getProjectMeasures() {
        return this.projectMeasures;
    }

    public Measure getProjectMeasure(Metric metric) {
        for (Measure measure : this.getProjectMeasures()) {
            if (!measure.getMetric().equals((Object)metric)) continue;
            return measure;
        }
        return null;
    }

    public List<Measure> getPackageMeasures() {
        return this.packageMeasures;
    }

    public List<Measure> getClassMeasures() {
        return this.classMeasures;
    }

    public List<RuleFailure> getClassRuleFailures() {
        return this.classRuleFailures;
    }

    public Measure getPackageMeasure(String packageName, Metric metric) {
        for (Measure measure : this.getPackageMeasures()) {
            if (!measure.ephemereSnapshot().getMavenProject().getKey().endsWith(packageName) || !measure.getMetric().equals((Object)metric)) continue;
            return measure;
        }
        return null;
    }

    public Measure getClassMeasure(String fullname, Metric metric) {
        for (Measure measure : this.getClassMeasures()) {
            if (!measure.ephemereSnapshot().getMavenProject().getKey().endsWith(fullname) || !measure.getMetric().equals((Object)metric)) continue;
            return measure;
        }
        return null;
    }
}

