/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.maven;

import ch.hortis.sonar.model.Metric;
import ch.hortis.sonar.service.MeasureKey;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.sonar.commons.database.AbstractDbUnitTestCase;
import org.sonar.plugins.api.maven.PlsqlMeasuresRecorder;

public class PlsqlMeasuresRecorderTest
extends AbstractDbUnitTestCase {
    private PlsqlMeasuresRecorder recorder;

    @Before
    public void before() throws Exception {
        this.recorder = new PlsqlMeasuresRecorder(this.getDao());
    }

    @After
    public void after() {
        this.recorder = null;
    }

    @Test
    public void shouldCreateDirectoryMeasures() throws Exception {
        this.setupData(new String[]{"shouldCreateDirectoryMeasures"});
        this.recorder.setRootSnapshot(this.getDao().getMeasuresDao().getSnapshot(1));
        this.recorder.createDirectoryMeasure("my/dir", new MeasureKey(this.getTestMetric()), Double.valueOf(100.8));
        this.getDao().stop();
        this.checkTables("shouldCreateDirectoryMeasures", new String[]{"projects", "snapshots", "project_measures"});
    }

    @Test
    public void shouldCreateDirectoryAndProjectRowsWhenCreatingFileMeasure() throws Exception {
        this.setupData(new String[]{"shouldCreateDirectoryAndProjectRowsWhenCreatingFileMeasure"});
        this.recorder.setRootSnapshot(this.getDao().getMeasuresDao().getSnapshot(1));
        this.recorder.createFileMeasure("my/dir", "myfile.plsql", new MeasureKey(this.getTestMetric()), Double.valueOf(100.8));
        this.getDao().stop();
        this.checkTables("shouldCreateDirectoryAndProjectRowsWhenCreatingFileMeasure", new String[]{"projects", "snapshots", "project_measures"});
    }

    @Test
    public void shouldCreateFileSource() throws Exception {
        this.setupData(new String[]{"shouldCreateFileSource"});
        this.recorder.setRootSnapshot(this.getDao().getMeasuresDao().getSnapshot(1));
        this.recorder.createFileSource("my/dir", "myfile.plsql", "my plsql code source");
        this.getDao().stop();
        this.checkTables("shouldCreateFileSource", new String[]{"projects", "snapshots", "snapshot_sources"});
    }

    private Metric getTestMetric() {
        return new Metric("ncss");
    }
}

