/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.maven.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.sonar.plugins.api.maven.model.Dependencies;
import org.sonar.plugins.api.maven.model.MavenPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesTest {
    @Test
    public void shouldGetEmptyDependenciesListWhenNoPlugins() {
        ArrayList plugins = new ArrayList();
        Dependencies dependencies = new Dependencies(plugins);
        MatcherAssert.assertThat((Object)dependencies.toUniqueList().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldGetEmptyDependenciesListWhenNoDependencies() {
        ArrayList<MavenPlugin> plugins = new ArrayList<MavenPlugin>();
        MavenPlugin plugin = new MavenPlugin(new Plugin());
        plugins.add(plugin);
        Dependencies dependencies = new Dependencies(plugins);
        MatcherAssert.assertThat((Object)dependencies.toUniqueList().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void shouldGetDependenciesList() {
        List<MavenPlugin> plugins = DependenciesTest.somePluginsWithThreeDifferentDependencies();
        Dependencies dependencies = new Dependencies(plugins);
        MatcherAssert.assertThat((Object)dependencies.toUniqueList().size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void shouldGetUniqueDependenciesListWhenDuplicates() {
        List<MavenPlugin> plugins = DependenciesTest.somePluginsWithDuplicatedDependencies();
        Dependencies dependencies = new Dependencies(plugins);
        MatcherAssert.assertThat((Object)dependencies.toUniqueList().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    private static List<MavenPlugin> somePluginsWithDuplicatedDependencies() {
        List<MavenPlugin> plugins = DependenciesTest.somePluginsWithDependencies();
        MavenPlugin plugin = plugins.get(0);
        plugin.addDependency("ignored", "artifact2", "ignored", "jar");
        return plugins;
    }

    private static List<MavenPlugin> somePluginsWithThreeDifferentDependencies() {
        List<MavenPlugin> plugins = DependenciesTest.somePluginsWithDependencies();
        MavenPlugin plugin = plugins.get(0);
        plugin.addDependency("foo", "bar", "baz", "jar");
        return plugins;
    }

    private static List<MavenPlugin> somePluginsWithDependencies() {
        ArrayList<MavenPlugin> plugins = new ArrayList<MavenPlugin>();
        plugins.add(DependenciesTest.aPluginWithDependency("1"));
        plugins.add(DependenciesTest.aPluginWithDependency("2"));
        return plugins;
    }

    private static MavenPlugin aPluginWithDependency(String id) {
        MavenPlugin plugin = new MavenPlugin(new Plugin());
        plugin.addDependency("groupdId", "artifact" + id, "version", "jar");
        return plugin;
    }
}

