/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.api.maven.model;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.plugins.api.maven.model.MavenPluginConfiguration;

public class MavenPluginConfigurationTest {
    private MavenPluginConfiguration config;

    @Test
    public void shouldWriteAndReadSimpleConfiguration() {
        this.config.setChildValue("abc", "test");
        Assert.assertThat((Object)this.config.getChildValue("abc"), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    public void shouldWriteAndReadComplexConfiguration() {
        this.config.setChildValue("abc/def/ghi", "test");
        Assert.assertThat((Object)this.config.getChildValue("abc/def/ghi"), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    public void shouldReturnNullWhenChildNotFound() {
        Assert.assertThat((Object)this.config.getChildValue("abc/def/ghi"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getChildValueShouldThrowExceptionWhenKeyIsNull() {
        this.config.getChildValue(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setChildValueShouldThrowExceptionWhenKeyIsNull() {
        this.config.setChildValue(null, null);
    }

    @Test
    public void shouldRemoveChild() {
        this.config.setChildValue("abc", "1");
        Assert.assertThat((Object)this.config.getChildValue("abc"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        this.config.removeChild("abc");
        Assert.assertThat((Object)this.config.getChildValue("abc"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldRemoveComplexChild() {
        this.config.setChildValue("abc/def", "1");
        Assert.assertThat((Object)this.config.getChildValue("abc/def"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        this.config.removeChild("abc/def");
        Assert.assertThat((Object)this.config.getChildValue("abc/def"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldRemoveComplexChildButLeaveTheParent() {
        this.config.setChildValue("abc/x", "1");
        this.config.setChildValue("abc/y", "2");
        this.config.removeChild("abc/x");
        Assert.assertThat((Object)this.config.getChildValue("abc/y"), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    public void shouldRemoveUnfoundChildWithoutError() {
        this.config.removeChild("abc/def");
        MavenPluginConfigurationTest.assertPassedWithoutError();
    }

    @Test
    public void shouldReturnChildCount() {
        this.config.setChildValue("abc/x", "1");
        this.config.setChildValue("abc/y", "2");
        Assert.assertThat((Object)this.config.getChildCount("abc"), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void shouldReturnChildCountWhenNoChild() {
        Assert.assertThat((Object)this.config.getChildCount("abc"), (Matcher)Matchers.is((Object)0));
    }

    @Before
    public void setUp() {
        this.config = new MavenPluginConfiguration();
    }

    private static void assertPassedWithoutError() {
        Assert.assertTrue((String)"For documentation only", (boolean)true);
    }
}

